/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.config;

import com.typesafe.config.Config;
import io.amient.affinity.core.util.JOption;
import java.io.Serializable;
import java.util.NoSuchElementException;

public abstract class Cfg<T>
implements Serializable {
    private String path;
    protected String relPath;
    private JOption<T> value = JOption.empty();
    private JOption<T> defaultValue = JOption.empty();
    protected boolean required = true;
    protected int listPos = -1;

    public abstract Cfg<T> apply(Config var1) throws IllegalArgumentException;

    public final <C extends Cfg<T>> C setValue(T value) {
        this.value = JOption.of(value);
        return (C)this;
    }

    public final T apply() {
        if (this.value.isPresent()) {
            return this.value.get();
        }
        if (this.defaultValue.isPresent()) {
            return this.defaultValue.get();
        }
        throw new NoSuchElementException(this.path + " is not defined");
    }

    public final String path() {
        return this.path == null ? "" : this.path;
    }

    public final String path(String relativePathToRsolve) {
        return (this.path == null ? "" : this.path + ".") + relativePathToRsolve;
    }

    public final boolean isDefined() {
        return this.value.isPresent() || this.defaultValue.isPresent();
    }

    void setOptional() {
        this.required = false;
    }

    void setPath(String path) {
        this.path = path;
    }

    void setListPos(int listPos) {
        this.listPos = listPos;
    }

    final void setRelPath(String relPath) {
        this.relPath = relPath;
    }

    final void setDefaultValue(T value) {
        this.defaultValue = JOption.of(value);
    }

    public static enum Options {
        STRICT,
        IGNORE_UNKNOWN;

    }
}

