/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.stream;

import com.typesafe.config.Config;
import io.amient.affinity.core.Murmur2Partitioner;
import io.amient.affinity.core.Partitioner;
import io.amient.affinity.core.storage.Storage;
import io.amient.affinity.stream.BinaryRecord;
import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public interface BinaryStream
extends Closeable {
    public static Class<? extends BinaryStream> bindClass() throws ClassNotFoundException {
        Class<?> cls = Class.forName("io.amient.affinity.stream.BinaryStreamImpl");
        return cls.asSubclass(BinaryStream.class);
    }

    public static BinaryStream bindNewInstance(Config config) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return BinaryStream.bindNewInstance((Storage.StorageConf)new Storage.StorageConf().apply(config));
    }

    public static BinaryStream bindNewInstance(Storage.StorageConf conf) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return BinaryStream.bindClass().getConstructor(Storage.StorageConf.class).newInstance(conf);
    }

    default public Partitioner getDefaultPartitioner() {
        return new Murmur2Partitioner();
    }

    public int getNumPartitions();

    public void subscribe();

    public void subscribe(int var1);

    public long lag();

    public Iterator<BinaryRecord> fetch(long var1);

    public void commit();

    public long publish(Iterator<BinaryRecord> var1);

    default public Iterator<BinaryRecord> iterator() {
        return new Iterator<BinaryRecord>(){
            private BinaryRecord record = null;
            private Iterator<BinaryRecord> i = null;

            @Override
            public boolean hasNext() {
                if (this.i == null) {
                    this.seek();
                }
                return this.record != null;
            }

            @Override
            public BinaryRecord next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                BinaryRecord result = this.record;
                this.seek();
                return result;
            }

            void seek() {
                this.record = null;
                while (this.i == null || !this.i.hasNext()) {
                    if (BinaryStream.this.lag() <= 0L) {
                        return;
                    }
                    this.i = BinaryStream.this.fetch(-1L);
                }
                if (this.i.hasNext()) {
                    this.record = this.i.next();
                }
            }
        };
    }
}

