/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.storage;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checkpoint {
    public final long offset;
    private static final Logger log = LoggerFactory.getLogger(Checkpoint.class);

    public Checkpoint(long offset) {
        this.offset = offset;
    }

    public String toString() {
        return "Checkpoint(offset: " + this.offset + ")";
    }

    public static Checkpoint readFromFile(Path file) throws IOException {
        long offset;
        List<String> lines = Files.readAllLines(file);
        try {
            offset = Long.valueOf(lines.get(0));
        }
        catch (Throwable e) {
            log.warn("Invalid checkpoint file: " + file + ", going to rewind fully.", e);
            offset = -1L;
        }
        return new Checkpoint(offset);
    }

    public void writeToFile(Path file) throws IOException {
        Files.write(file, Arrays.asList(String.valueOf(this.offset)), new OpenOption[0]);
    }
}

