/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.storage;

import io.amient.affinity.core.config.CfgCls;
import io.amient.affinity.core.config.CfgStruct;
import io.amient.affinity.core.storage.MemStore;
import io.amient.affinity.core.storage.StateConf;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;

public abstract class Storage {
    public final MemStore memstore;
    public final int partition;

    public Storage(StateConf conf, int partition) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this.partition = partition;
        Class memstoreClass = (Class)conf.MemStore.Class.apply();
        Constructor memstoreConstructor = memstoreClass.getConstructor(StateConf.class);
        this.memstore = (MemStore)memstoreConstructor.newInstance(conf);
        this.memstore.open();
    }

    public abstract void init();

    public abstract void boot();

    public abstract void tail();

    public final void close() {
        try {
            this.stop();
        }
        finally {
            this.memstore.close();
        }
    }

    protected abstract void stop();

    public abstract Future<Long> write(byte[] var1, byte[] var2, long var3);

    public abstract Future<Long> delete(byte[] var1);

    public static class StorageConf
    extends CfgStruct<StorageConf> {
        public CfgCls<Storage> Class = this.cls("class", Storage.class, true);

        @Override
        protected Set<String> specializations() {
            return new HashSet<String>(Arrays.asList("kafka"));
        }
    }
}

