/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.storage;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;

public class Checkpoint {
    public final long offset;
    public final boolean closed;

    public Checkpoint(long offset, boolean closed) {
        this.offset = offset;
        this.closed = closed;
    }

    public String toString() {
        return "Checkpoint(offset: " + this.offset + ")";
    }

    public static Checkpoint readFromFile(Path file) throws IOException {
        List<String> lines = Files.readAllLines(file);
        long offset = Long.valueOf(lines.get(0));
        boolean closed = lines.size() >= 2 && lines.get(1).equals("CLOSED");
        return new Checkpoint(offset, closed);
    }

    public void writeToFile(Path file) throws IOException {
        Files.write(file, Arrays.asList(String.valueOf(this.offset), this.closed ? "CLOSED" : "OPEN"), new OpenOption[0]);
    }
}

