/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.storage;

import com.typesafe.config.Config;
import io.amient.affinity.core.storage.MemStore;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;

public abstract class Storage {
    public static final String CONFIG_MEMSTORE_CLASS = "memstore.class";
    public final MemStore memstore;

    public Storage(Config config, int partition) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        MemStore tmp;
        Class<MemStore> memstoreClass = Class.forName(config.getString(CONFIG_MEMSTORE_CLASS)).asSubclass(MemStore.class);
        try {
            Constructor<MemStore> memstoreConstructor = memstoreClass.getConstructor(Config.class, Integer.TYPE);
            tmp = memstoreConstructor.newInstance(config, partition);
        }
        catch (NoSuchMethodException e) {
            Constructor<MemStore> memstoreConstructor = memstoreClass.getConstructor(new Class[0]);
            tmp = memstoreConstructor.newInstance(new Object[0]);
        }
        this.memstore = tmp;
    }

    public abstract void init();

    public abstract void boot();

    public abstract void tail();

    public final void close() {
        try {
            this.stop();
        }
        finally {
            this.memstore.close();
        }
    }

    protected abstract void stop();

    public abstract Future<?> write(ByteBuffer var1, ByteBuffer var2);

    public abstract Future<?> delete(ByteBuffer var1);
}

