/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.util;

import io.amient.affinity.core.util.TimeCryptoProof;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.xml.bind.DatatypeConverter;

public class TimeCryptoProofSHA256
extends TimeCryptoProof {
    public TimeCryptoProofSHA256(byte[] salt) {
        super(salt);
    }

    public TimeCryptoProofSHA256(String hexSalt) {
        super(hexSalt);
    }

    @Override
    protected byte[] hash(byte[] input) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        return digest.digest(input);
    }

    public String timeBasedHash(String arg, String hexSalt, int shift) throws Exception {
        byte[] salt = DatatypeConverter.parseHexBinary((String)hexSalt);
        long utcWholeMinute = ZonedDateTime.now(ZoneOffset.UTC).withNano(0).withSecond(0).toEpochSecond() + (long)(shift * 60);
        byte[] argBytes = arg.getBytes();
        ByteBuffer in = ByteBuffer.allocate(salt.length + 8 + argBytes.length);
        in.put(salt);
        in.putLong(utcWholeMinute);
        in.put(argBytes);
        in.flip();
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(in.array());
        String hexHash = DatatypeConverter.printHexBinary((byte[])hash);
        return hexHash;
    }
}

