/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.util;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Random;
import javax.xml.bind.DatatypeConverter;

public abstract class TimeCryptoProof {
    private static Random random = new SecureRandom();
    private final byte[] salt;

    public static String toHex(byte[] bytes) {
        return DatatypeConverter.printHexBinary((byte[])bytes);
    }

    public static byte[] fromHex(String hex) {
        return DatatypeConverter.parseHexBinary((String)hex);
    }

    public static byte[] generateSalt() {
        byte[] bytes = new byte[16];
        Arrays.fill(bytes, (byte)0);
        random.nextBytes(bytes);
        return bytes;
    }

    private static long utcInWholeMinutes(int offset) {
        return ZonedDateTime.now(ZoneOffset.UTC).withNano(0).withSecond(0).toEpochSecond() + (long)(offset * 60);
    }

    public TimeCryptoProof(byte[] salt) {
        this.salt = salt;
    }

    public TimeCryptoProof(String hexSalt) {
        this.salt = TimeCryptoProof.fromHex(hexSalt);
    }

    public final String sign(String arg) throws Exception {
        return TimeCryptoProof.toHex(this.sign(arg.getBytes("UTF-8")));
    }

    public final byte[] sign(byte[] arg) throws Exception {
        return this.sign(arg, TimeCryptoProof.utcInWholeMinutes(0));
    }

    private byte[] sign(byte[] arg, long utc) throws Exception {
        ByteBuffer in = ByteBuffer.allocate(this.salt.length + 8 + arg.length);
        in.put(this.salt);
        in.putLong(utc);
        in.put(arg);
        in.flip();
        return this.hash(in.array());
    }

    public final boolean verify(String signature, String arg) throws Exception {
        return this.verify(TimeCryptoProof.fromHex(signature), arg.getBytes("UTF-8"));
    }

    public final boolean verify(byte[] signature, byte[] arg) throws Exception {
        return Arrays.equals(this.sign(arg, TimeCryptoProof.utcInWholeMinutes(0)), signature) || Arrays.equals(this.sign(arg, TimeCryptoProof.utcInWholeMinutes(-1)), signature) || Arrays.equals(this.sign(arg, TimeCryptoProof.utcInWholeMinutes(1)), signature);
    }

    protected abstract byte[] hash(byte[] var1) throws Exception;
}

