/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class JavaPromise<T>
implements Future<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private T value;
    private Exception exception;

    public void failure(Exception e) {
        this.exception = e;
        this.latch.countDown();
    }

    public void success(T result) {
        this.value = result;
        this.latch.countDown();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException {
        this.latch.await();
        if (this.exception != null) {
            throw new RuntimeException(this.exception);
        }
        return this.value;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (this.latch.await(timeout, unit)) {
            return this.value;
        }
        throw new TimeoutException();
    }
}

