/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.state;

import io.amient.affinity.core.state.ObservableKVStore;
import io.amient.affinity.core.state.ObservableKeyValue;
import io.amient.affinity.core.storage.Record;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public abstract class ObservableState<K>
extends Observable
implements ObservableKVStore<K> {
    private Map<K, ObservableKeyValue> observables = new HashMap<K, ObservableKeyValue>();

    private ObservableKeyValue getOrCreate(K key) {
        ObservableKeyValue observable = this.observables.get(key);
        if (observable == null) {
            observable = new ObservableKeyValue();
            this.observables.put(key, observable);
        }
        return observable;
    }

    @Override
    public ObservableKeyValue addKeyValueObserver(K key, Observer observer) {
        ObservableKeyValue observable = this.getOrCreate(key);
        observable.addObserver(observer);
        return observable;
    }

    @Override
    public Observer addKeyValueObserver(K key, Object initEvent, Observer observer) {
        ObservableKeyValue observable = this.getOrCreate(key);
        observable.addObserver(observer);
        observer.update(observable, initEvent);
        return observer;
    }

    @Override
    public void removeKeyValueObserver(K key, Observer observer) {
        ObservableKeyValue observable = this.observables.get(key);
        if (observable != null) {
            observable.deleteObserver(observer);
            if (observable.countObservers() == 0) {
                this.observables.remove(key);
            }
        }
    }

    public void push(Record<K, ?> record) {
        try {
            ObservableKeyValue observable = this.observables.get(record.key);
            if (observable != null) {
                observable.notifyObservers(record);
            }
        }
        finally {
            this.setChanged();
            this.notifyObservers(record);
        }
    }

    public abstract void internalPush(Record<byte[], byte[]> var1);
}

