/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.framework.api.docs;

import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class ApiDocsConfig {
    private static final String CORRELATION_ID = "Correlation-ID";
    private static final String CLIENT_APP_ID = "Client-App-ID";
    private static final String HEADER = "Header";
    private String teamName = "Team Synapse";
    private String teamWebsite = "https://americanexpress.io/synapse/";
    private String teamEmailAddress = "synapse@aexp.com";
    private String title = "Synapse APIs";
    private String description = "These are the specifications of the Synapse APIs";

    public String getTeamName() {
        return this.teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public String getTeamWebsite() {
        return this.teamWebsite;
    }

    public void setTeamWebsite(String teamWebsite) {
        this.teamWebsite = teamWebsite;
    }

    public String getTeamEmailAddress() {
        return this.teamEmailAddress;
    }

    public void setTeamEmailAddress(String teamEmailAddress) {
        this.teamEmailAddress = teamEmailAddress;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Bean
    public Docket synapseApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.getApiInformation()).select().apis(RequestHandlerSelectors.withClassAnnotation(RestController.class)).paths(PathSelectors.any()).build().securityContexts((List)Lists.newArrayList((Object[])new SecurityContext[]{this.getSecurityContext()}));
    }

    private ApiInfo getApiInformation() {
        Contact contact = new Contact(this.getTeamName(), this.getTeamWebsite(), this.getTeamEmailAddress());
        return new ApiInfoBuilder().title(this.getTitle()).description(this.getDescription()).contact(contact).version("1.0").build();
    }

    private List<ApiKey> getApiKeys() {
        return Lists.newArrayList((Object[])new ApiKey[]{new ApiKey(CORRELATION_ID, CORRELATION_ID, HEADER), new ApiKey(CLIENT_APP_ID, CLIENT_APP_ID, HEADER)});
    }

    private SecurityContext getSecurityContext() {
        return SecurityContext.builder().securityReferences(this.getDefaultSecurityReferences()).forPaths(PathSelectors.any()).build();
    }

    private List<SecurityReference> getDefaultSecurityReferences() {
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{};
        return Lists.newArrayList((Object[])new SecurityReference[]{new SecurityReference(CORRELATION_ID, authorizationScopes), new SecurityReference(CLIENT_APP_ID, authorizationScopes)});
    }
}

