///**
// * Copyright (C) 2018 Alauda
// *
// * Licensed under the Apache License, Version 2.0 (the "License");
// * you may not use this file except in compliance with the License.
// * You may obtain a copy of the License at
// *
// *         http://www.apache.org/licenses/LICENSE-2.0
// *
// * Unless required by applicable law or agreed to in writing, software
// * distributed under the License is distributed on an "AS IS" BASIS,
// * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// * See the License for the specific language governing permissions and
// * limitations under the License.
// */
//package io.alauda.devops.client.handlers;
//
//import io.alauda.devops.client.AlaudaDevOpsConfig;
//import io.alauda.devops.client.dsl.internal.PolicyOperationsImpl;
//import io.alauda.kubernetes.client.Watch;
//import io.alauda.kubernetes.client.Watcher;
//import okhttp3.OkHttpClient;
//import io.alauda.kubernetes.client.Config;
//import io.alauda.kubernetes.client.ResourceHandler;
//import io.alauda.devops.api.model.Policy;
//import io.alauda.devops.api.model.PolicyBuilder;
//import org.apache.felix.scr.annotations.Component;
//import org.apache.felix.scr.annotations.Service;
//
//import java.util.TreeMap;
//import java.util.concurrent.TimeUnit;
//
//@Component
//@Service
//public class PolicyHandler implements ResourceHandler<Policy, PolicyBuilder> {
//  @Override
//  public String getKind() {
//    return Policy.class.getSimpleName();
//  }
//
//  @Override
//  public Policy create(OkHttpClient client, Config config, String namespace, Policy item) {
//      return new PolicyOperationsImpl(client, AlaudaDevOpsConfig.wrap(config), null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).create();
//    }
//
//  @Override
//  public Policy replace(OkHttpClient client, Config config, String namespace, Policy item) {
//    return new PolicyOperationsImpl(client, AlaudaDevOpsConfig.wrap(config), null, namespace, null, true, item, null, true, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).replace(item);
//  }
//
//  @Override
//  public Policy reload(OkHttpClient client, Config config, String namespace, Policy item) {
//    return new PolicyOperationsImpl(client, AlaudaDevOpsConfig.wrap(config), null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).fromServer().get();
//  }
//
//  @Override
//  public PolicyBuilder edit(Policy item) {
//    return new PolicyBuilder(item);
//  }
//
//  @Override
//  public Boolean delete(OkHttpClient client, Config config, String namespace, Policy item) {
//      return new PolicyOperationsImpl(client, AlaudaDevOpsConfig.wrap(config), null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).delete(item);
//    }
//
//  @Override
//  public Watch watch(OkHttpClient client, Config config, String namespace, Policy item, Watcher<Policy> watcher) {
//    return new PolicyOperationsImpl(client, AlaudaDevOpsConfig.wrap(config), null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).watch(watcher);
//  }
//
//  @Override
//  public Watch watch(OkHttpClient client, Config config, String namespace, Policy item, String resourceVersion, Watcher<Policy> watcher) {
//    return new PolicyOperationsImpl(client, AlaudaDevOpsConfig.wrap(config), null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).watch(resourceVersion, watcher);
//  }
//
//  @Override
//  public Policy waitUntilReady(OkHttpClient client, Config config, String namespace, Policy item, long amount, TimeUnit timeUnit) throws InterruptedException {
//    return new PolicyOperationsImpl(client, AlaudaDevOpsConfig.wrap(config), null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).waitUntilReady(amount, timeUnit);
//  }
//}
