package io.alauda.devops.client.dsl.internal;

import io.alauda.devops.client.AlaudaAPIGroups;
import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.devops.client.dsl.PipelineTaskTemplateResource;
import io.alauda.kubernetes.api.model.DoneablePipelineTaskTemplate;
import io.alauda.kubernetes.api.model.PipelineTaskTemplate;
import io.alauda.kubernetes.api.model.PipelineTaskTemplateList;
import okhttp3.OkHttpClient;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import java.util.TreeMap;

public class PipelineTaskTemplateOperationsImpl extends AlaudaOperation<PipelineTaskTemplate, PipelineTaskTemplateList, DoneablePipelineTaskTemplate, PipelineTaskTemplateResource<PipelineTaskTemplate, DoneablePipelineTaskTemplate, Void, PipelineTaskTemplate>>
  implements PipelineTaskTemplateResource<PipelineTaskTemplate, DoneablePipelineTaskTemplate, Void, PipelineTaskTemplate> {

  private final InputStream in;
  private final OutputStream out;
  private final OutputStream err;

  private final PipedOutputStream inPipe;
  private final PipedInputStream outPipe;
  private final PipedInputStream errPipe;
  private final boolean withTTY;
  private final boolean withTerminatedStatus;
  private final boolean withTimestamps;
  private final String sinceTimestamp;
  private final Integer sinceSeconds;
  private final Integer withTailingLines;
  private final boolean withPrettyOutput;
  private final String version;
  private final Integer limitBytes;

  public PipelineTaskTemplateOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String namespace) {
    this(client, config, null, namespace, null, true, null, "0", false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, false, false, false, null, null, null, false, null, null);
  }

  public PipelineTaskTemplateOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion, String namespace, String name, Boolean cascading, PipelineTaskTemplate item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
    this(client, config, apiVersion, namespace, name, cascading, item, resourceVersion, reloadingFromServer, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, false, false, false, null, null, null, false, null, null);
  }

  public PipelineTaskTemplateOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion, String namespace, String name, Boolean cascading, PipelineTaskTemplate item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, InputStream in, OutputStream out, OutputStream err, PipedOutputStream inPipe, PipedInputStream outPipe, PipedInputStream errPipe, boolean withTTY, boolean withTerminatedStatus, boolean withTimestamps, String sinceTimestamp, Integer sinceSeconds, Integer withTailingLines, boolean withPrettyOutput, String version, Integer limitBytes) {
    super(client, AlaudaOperation.withApiGroup(client, AlaudaAPIGroups.DEVOPS, apiVersion, config), "pipelinetasktemplates", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
    this.in = in;
    this.out = out;
    this.err = err;
    this.inPipe = inPipe;
    this.outPipe = outPipe;
    this.errPipe = errPipe;
    this.withTTY = withTTY;
    this.withTerminatedStatus = withTerminatedStatus;
    this.withTimestamps = withTimestamps;
    this.sinceTimestamp = sinceTimestamp;
    this.sinceSeconds = sinceSeconds;
    this.withTailingLines = withTailingLines;
    this.withPrettyOutput = withPrettyOutput;
    this.version = version;
    this.limitBytes = limitBytes;
  }
}
