/**
 * Copyright (C) 2018 Alauda
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.alauda.devops.client;

import java.net.URL;

import io.alauda.devops.client.dsl.*;
import io.alauda.kubernetes.api.model.*;
import io.alauda.kubernetes.client.KubernetesClient;
import io.alauda.kubernetes.client.dsl.*;

public interface AlaudaDevOpsClient extends KubernetesClient {

  URL getKubernetesUrl();

  ExtensionsAPIGroupDSL extensions();

  AppsAPIGroupDSL apps();

  AutoscalingAPIGroupDSL autoscaling();

  MixedOperation<Pipeline, PipelineList, DoneablePipeline, PipelineResource<Pipeline, DoneablePipeline, String, LogWatch>> pipelines();

  MixedOperation<PipelineConfig, PipelineConfigList, DoneablePipelineConfig, PipelineConfigResource<PipelineConfig, DoneablePipelineConfig, Void, Pipeline>> pipelineConfigs();

  MixedOperation<PipelineTemplate, PipelineTemplateList, DoneablePipelineTemplate, PipelineTemplateResource<PipelineTemplate, DoneablePipelineTemplate, Void, PipelineTemplate>> pipelinetemplates();

  MixedOperation<PipelineTaskTemplate, PipelineTaskTemplateList, DoneablePipelineTaskTemplate, PipelineTaskTemplateResource<PipelineTaskTemplate, DoneablePipelineTaskTemplate, Void, PipelineTaskTemplate>> pipelinetasktemplates();

  NonNamespaceOperation<ClusterPipelineTemplate, ClusterPipelineTemplateList, DoneableClusterPipelineTemplate, ClusterPipelineTemplateResource<ClusterPipelineTemplate, DoneableClusterPipelineTemplate, Void, ClusterPipelineTemplate>> clusterPipelinetemplates();

  NonNamespaceOperation<ClusterPipelineTaskTemplate, ClusterPipelineTaskTemplateList, DoneableClusterPipelineTaskTemplate, ClusterPipelineTaskTemplateResource<ClusterPipelineTaskTemplate, DoneableClusterPipelineTaskTemplate, Void, ClusterPipelineTaskTemplate>> clusterPipelinetasktemplates();

  NonNamespaceOperation<Jenkins, JenkinsList, DoneableJenkins, Resource<Jenkins, DoneableJenkins>> jenkins();

  MixedOperation<JenkinsBinding, JenkinsBindingList, DoneableJenkinsBinding, Resource<JenkinsBinding, DoneableJenkinsBinding>> jenkinsBindings();

  MixedOperation<CodeRepository, CodeRepositoryList, DoneableCodeRepository, Resource<CodeRepository, DoneableCodeRepository>> codeRepositories();

  MixedOperation<CodeRepoBinding, CodeRepoBindingList, DoneableCodeRepoBinding, Resource<CodeRepoBinding, DoneableCodeRepoBinding>> codeRepoBindings();

  MixedOperation<CodeRepoService, CodeRepoServiceList, DoneableCodeRepoService, Resource<CodeRepoService, DoneableCodeRepoService>> codeRepoServices();

  /**
   * Returns true if this cluster is a legacy devops cluster or supports the given OpenShift API Group defined in {@link AlaudaAPIGroups}
   */
  boolean supportAlaudaAPIGroup(String apiGroup);
}
