package io.alauda.devops.client.dsl.internal;

import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.kubernetes.api.model.CodeRepoService;
import io.alauda.kubernetes.api.model.CodeRepoServiceList;
import io.alauda.kubernetes.api.model.DoneableCodeRepoService;
import io.alauda.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import java.util.Map;
import java.util.TreeMap;

import static io.alauda.devops.client.AlaudaAPIGroups.DEVOPS;

public class CodeRepoServiceOperationsImpl extends AlaudaOperation<CodeRepoService, CodeRepoServiceList, DoneableCodeRepoService, Resource<CodeRepoService, DoneableCodeRepoService>> {
  public CodeRepoServiceOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String namespace) {
    this(client, config, null, namespace, null, true, null, "0", false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
  }

  public CodeRepoServiceOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion, String namespace, String name, Boolean cascading, CodeRepoService item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
    super(client, AlaudaOperation.withApiGroup(client, DEVOPS, apiVersion, config), "codereposervices", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
  }
}
