/**
 * Copyright (C) 2018 Alauda
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.alauda.devops.client;

/**
 * Defines constants for all the OpenShift API Groups
 */
public class AlaudaAPIGroups {
  public static final String AUTHORIZATION = "authorization.devops.io";
  public static final String BUILD = "build.devops.io";
  public static final String APPS = "apps.devops.io";
  public static final String TEMPLATE = "template.devops.io";
  public static final String IMAGE = "image.devops.io";
  public static final String USER = "user.devops.io";
  public static final String OAUTH = "oauth.devops.io";
  public static final String NETWORK = "network.devops.io";
  public static final String ROUTE = "route.devops.io";
  public static final String DEVOPS = "devops.alauda.io";
  public static final String CHARTS = "charts.alauda.io";
  public static String getVersionByAPIGroup(String group)  {
    switch (group) {
      case DEVOPS:
        return "v1alpha1";
      case CHARTS:
        return "v1alpha1";
      default:
        return null;
    }
  }
}


