///**
// * Copyright (C) 2018 Alauda
// *
// * Licensed under the Apache License, Version 2.0 (the "License");
// * you may not use this file except in compliance with the License.
// * You may obtain a copy of the License at
// *
// *         http://www.apache.org/licenses/LICENSE-2.0
// *
// * Unless required by applicable law or agreed to in writing, software
// * distributed under the License is distributed on an "AS IS" BASIS,
// * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// * See the License for the specific language governing permissions and
// * limitations under the License.
// */
//
//package io.alauda.devops.client.osgi;
//
//import io.alauda.kubernetes.api.model.*;
//import io.alauda.kubernetes.api.model.extensions.DoneablePodSecurityPolicy;
//import io.alauda.kubernetes.api.model.extensions.PodSecurityPolicy;
//import io.alauda.kubernetes.api.model.extensions.PodSecurityPolicyList;
//import io.alauda.devops.client.AlaudaDevOpsClient;
//import io.alauda.devops.client.AlaudaDevOpsConfig;
//import io.alauda.devops.client.DefaultAlaudaDevOpsClient;
//import io.alauda.devops.client.NamespacedAlaudaDevOpsClient;
//import io.alauda.devops.client.dsl.*;
//import io.alauda.kubernetes.api.model.apiextensions.CustomResourceDefinition;
//import io.alauda.kubernetes.api.model.apiextensions.CustomResourceDefinitionList;
//import io.alauda.kubernetes.api.model.apiextensions.DoneableCustomResourceDefinition;
//import io.alauda.kubernetes.client.BaseClient;
//import io.alauda.kubernetes.client.Config;
//import io.alauda.kubernetes.client.RequestConfig;
//import io.alauda.kubernetes.client.dsl.AppsAPIGroupDSL;
//import io.alauda.kubernetes.client.dsl.AutoscalingAPIGroupDSL;
//import io.alauda.kubernetes.client.dsl.KubernetesListMixedOperation;
//import io.alauda.kubernetes.client.dsl.MixedOperation;
//import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
//import io.alauda.kubernetes.client.dsl.ParameterMixedOperation;
//import io.alauda.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
//import io.alauda.kubernetes.client.dsl.PodResource;
//import io.alauda.kubernetes.client.dsl.Resource;
//import io.alauda.kubernetes.client.dsl.RollableScalableResource;
//import io.alauda.kubernetes.client.dsl.ExtensionsAPIGroupDSL;
//import io.alauda.kubernetes.client.dsl.FunctionCallable;
//import io.alauda.kubernetes.client.dsl.LogWatch;
//import io.alauda.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
//import io.alauda.kubernetes.client.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
//import io.alauda.devops.client.AlaudaDevOpsConfigBuilder;
//import org.apache.felix.scr.annotations.Activate;
//import org.apache.felix.scr.annotations.Component;
//import org.apache.felix.scr.annotations.ConfigurationPolicy;
//import org.apache.felix.scr.annotations.Deactivate;
//import org.apache.felix.scr.annotations.Service;
//
//import java.io.InputStream;
//import java.net.URL;
//import java.util.Collection;
//import java.util.Map;
//
//import static io.alauda.kubernetes.client.Config.KUBERNETES_API_VERSION_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_AUTH_BASIC_PASSWORD_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_AUTH_BASIC_USERNAME_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_CA_CERTIFICATE_DATA_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_CA_CERTIFICATE_FILE_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_CLIENT_CERTIFICATE_DATA_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_CLIENT_CERTIFICATE_FILE_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_CLIENT_KEY_ALGO_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_CLIENT_KEY_DATA_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_CLIENT_KEY_FILE_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_CLIENT_KEY_PASSPHRASE_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_HTTPS_PROXY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_HTTP_PROXY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_MASTER_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_NAMESPACE_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_NO_PROXY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_OAUTH_TOKEN_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_REQUEST_TIMEOUT_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_WATCH_RECONNECT_INTERVAL_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_WATCH_RECONNECT_LIMIT_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_WEBSOCKET_PING_INTERVAL_SYSTEM_PROPERTY;
//import static io.alauda.kubernetes.client.Config.KUBERNETES_WEBSOCKET_TIMEOUT_SYSTEM_PROPERTY;
//
//@Component(immediate = true, configurationPid = "io.alauda.devops.client", policy = ConfigurationPolicy.OPTIONAL)
//@Service({AlaudaDevOpsClient.class, NamespacedAlaudaDevOpsClient.class})
//public class ManagedAlaudaDevOpsClient extends BaseClient implements NamespacedAlaudaDevOpsClient {
//
//  private DefaultAlaudaDevOpsClient delegate;
//
//  @Activate
//  public void activate(Map<String, Object> properties) {
//    final AlaudaDevOpsConfigBuilder builder = new AlaudaDevOpsConfigBuilder();
//
//    if (properties.containsKey(KUBERNETES_MASTER_SYSTEM_PROPERTY)) {
//      builder.withMasterUrl((String) properties.get(KUBERNETES_MASTER_SYSTEM_PROPERTY));
//    }
//    if (properties.containsKey(KUBERNETES_API_VERSION_SYSTEM_PROPERTY)) {
//      builder.withApiVersion((String) properties.get(KUBERNETES_API_VERSION_SYSTEM_PROPERTY));
//    }
//    if (properties.containsKey(KUBERNETES_NAMESPACE_SYSTEM_PROPERTY)) {
//      builder.withNamespace((String) properties.get(KUBERNETES_NAMESPACE_SYSTEM_PROPERTY));
//    }
//    if (properties.containsKey(KUBERNETES_CA_CERTIFICATE_FILE_SYSTEM_PROPERTY)) {
//      builder.withCaCertFile((String) properties.get(KUBERNETES_CA_CERTIFICATE_FILE_SYSTEM_PROPERTY));
//    }
//    if (properties.containsKey(KUBERNETES_CA_CERTIFICATE_DATA_SYSTEM_PROPERTY)) {
//      builder.withCaCertData((String) properties.get(KUBERNETES_CA_CERTIFICATE_DATA_SYSTEM_PROPERTY));
//    }
//    if (properties.containsKey(KUBERNETES_CLIENT_CERTIFICATE_FILE_SYSTEM_PROPERTY)) {
//      builder.withClientCertFile((String) properties.get(KUBERNETES_CLIENT_CERTIFICATE_FILE_SYSTEM_PROPERTY));
//    }
//    if (properties.containsKey(KUBERNETES_CLIENT_CERTIFICATE_DATA_SYSTEM_PROPERTY)) {
//      builder.withClientCertData((String) properties.get(KUBERNETES_CLIENT_CERTIFICATE_DATA_SYSTEM_PROPERTY));
//    }
//    if (properties.containsKey(KUBERNETES_CLIENT_KEY_FILE_SYSTEM_PROPERTY)) {
//      builder.withClientKeyFile((String) properties.get(KUBERNETES_CLIENT_KEY_FILE_SYSTEM_PROPERTY));
//    }
//    if (properties.containsKey(KUBERNETES_CLIENT_KEY_DATA_SYSTEM_PROPERTY)) {
//      builder.withClientKeyData((String) properties.get(KUBERNETES_CLIENT_KEY_DATA_SYSTEM_PROPERTY));
//    }
//    if (properties.containsKey(KUBERNETES_CLIENT_KEY_ALGO_SYSTEM_PROPERTY)) {
//      builder.withClientKeyAlgo((String) properties.get(KUBERNETES_CLIENT_KEY_ALGO_SYSTEM_PROPERTY));
//    }
//    if (properties.containsKey(KUBERNETES_CLIENT_KEY_PASSPHRASE_SYSTEM_PROPERTY)) {
//      builder.withClientKeyPassphrase((String) properties.get(KUBERNETES_CLIENT_KEY_PASSPHRASE_SYSTEM_PROPERTY));
//    }
//    if (properties.containsKey(KUBERNETES_AUTH_BASIC_USERNAME_SYSTEM_PROPERTY)) {
//      builder.withUsername((String) properties.get(KUBERNETES_AUTH_BASIC_USERNAME_SYSTEM_PROPERTY));
//    }
//    if (properties.containsKey(KUBERNETES_AUTH_BASIC_PASSWORD_SYSTEM_PROPERTY)) {
//      builder.withPassword((String) properties.get(KUBERNETES_AUTH_BASIC_PASSWORD_SYSTEM_PROPERTY));
//    }
//    if (properties.containsKey(KUBERNETES_OAUTH_TOKEN_SYSTEM_PROPERTY)) {
//      builder.withOauthToken((String) properties.get(KUBERNETES_OAUTH_TOKEN_SYSTEM_PROPERTY));
//    }
//    if (properties.containsKey(KUBERNETES_WATCH_RECONNECT_INTERVAL_SYSTEM_PROPERTY)) {
//      builder.withWatchReconnectInterval(Integer.parseInt((String) properties.get(KUBERNETES_WATCH_RECONNECT_INTERVAL_SYSTEM_PROPERTY)));
//    }
//    if (properties.containsKey(KUBERNETES_WATCH_RECONNECT_LIMIT_SYSTEM_PROPERTY)) {
//      builder.withWatchReconnectLimit(Integer.parseInt((String) properties.get(KUBERNETES_WATCH_RECONNECT_LIMIT_SYSTEM_PROPERTY)));
//    }
//    if (properties.containsKey(KUBERNETES_REQUEST_TIMEOUT_SYSTEM_PROPERTY)) {
//      builder.withRequestTimeout(Integer.parseInt((String) properties.get(KUBERNETES_REQUEST_TIMEOUT_SYSTEM_PROPERTY)));
//    }
//    if (properties.containsKey(KUBERNETES_HTTP_PROXY)) {
//      builder.withHttpProxy((String) properties.get(KUBERNETES_HTTP_PROXY));
//    }
//    if (properties.containsKey(KUBERNETES_HTTPS_PROXY)) {
//      builder.withHttpsProxy((String) properties.get(KUBERNETES_HTTPS_PROXY));
//    }
//    if (properties.containsKey(KUBERNETES_NO_PROXY)) {
//      String noProxyProperty = (String) properties.get(KUBERNETES_NO_PROXY);
//      builder.withNoProxy(noProxyProperty.split(","));
//    }
//    if (properties.containsKey(AlaudaDevOpsConfig.ALAUDA_BUILD_TIMEOUT_SYSTEM_PROPERTY)) {
//      builder.withBuildTimeout(Integer.parseInt((String) properties.get(AlaudaDevOpsConfig.ALAUDA_BUILD_TIMEOUT_SYSTEM_PROPERTY)));
//    } else {
//      builder.withBuildTimeout(AlaudaDevOpsConfig.DEFAULT_BUILD_TIMEOUT);
//    }
//    if (properties.containsKey(KUBERNETES_WEBSOCKET_TIMEOUT_SYSTEM_PROPERTY)) {
//      builder.withWebsocketTimeout(Long.parseLong((String) properties.get(KUBERNETES_WEBSOCKET_TIMEOUT_SYSTEM_PROPERTY)));
//    }
//    if (properties.containsKey(KUBERNETES_WEBSOCKET_PING_INTERVAL_SYSTEM_PROPERTY)) {
//      builder.withWebsocketPingInterval(Long.parseLong((String) properties.get(KUBERNETES_WEBSOCKET_PING_INTERVAL_SYSTEM_PROPERTY)));
//    }
//
//    delegate = new DefaultAlaudaDevOpsClient(builder.build());
//  }
//
//  @Deactivate
//  public void deactivate() {
//    delegate.close();
//  }
//
//  @Override
//  public URL getKubernetesUrl() {
//    return delegate.getKubernetesUrl();
//  }
//
//  @Override
//  public MixedOperation<ComponentStatus, ComponentStatusList, DoneableComponentStatus, Resource<ComponentStatus, DoneableComponentStatus>> componentstatuses() {
//    return delegate.componentstatuses();
//  }
//
//  @Override
//  public MixedOperation<Pipeline, PipelineList, DoneablePipeline, PipelineResource<Pipeline, DoneablePipeline, String, LogWatch>> pipelines() {
//    return delegate.pipelines();
//  }
//
//  @Override
//  public MixedOperation<PipelineTemplate, PipelineTemplateList, DoneablePipelineTemplate, PipelineTemplateResource<PipelineTemplate, DoneablePipelineTemplate, Void, PipelineTemplate>> pipelinetemplates() {
//    return delegate.pipelinetemplates();
//  }
//
//  @Override
//  public MixedOperation<PipelineTaskTemplate, PipelineTaskTemplateList, DoneablePipelineTaskTemplate, PipelineTaskTemplateResource<PipelineTaskTemplate, DoneablePipelineTaskTemplate, Void, PipelineTaskTemplate>> pipelinetasktemplates() {
//    return delegate.pipelinetasktemplates();
//  }
//
//  @Override
//  public NonNamespaceOperation<ClusterPipelineTemplate, ClusterPipelineTemplateList, DoneableClusterPipelineTemplate, ClusterPipelineTemplateResource<ClusterPipelineTemplate, DoneableClusterPipelineTemplate, Void, ClusterPipelineTemplate>> clusterPipelinetemplates() {
//    return delegate.clusterPipelinetemplates();
//  }
//
//  @Override
//  public NonNamespaceOperation<ClusterPipelineTaskTemplate, ClusterPipelineTaskTemplateList, DoneableClusterPipelineTaskTemplate, ClusterPipelineTaskTemplateResource<ClusterPipelineTaskTemplate, DoneableClusterPipelineTaskTemplate, Void, ClusterPipelineTaskTemplate>> clusterPipelinetasktemplates() {
//    return delegate.clusterPipelinetasktemplates();
//  }
//
//  @Override
//  public MixedOperation<PipelineConfig, PipelineConfigList, DoneablePipelineConfig, PipelineConfigResource<PipelineConfig, DoneablePipelineConfig, Void, Pipeline>> pipelineConfigs() {
//    return delegate.pipelineConfigs();
//  }
//
//  @Override
//  public NonNamespaceOperation<Project, ProjectList, DoneableProject, Resource<Project, DoneableProject>> projects() {
//    return delegate.projects();
//  }
//
//  @Override
//  public NonNamespaceOperation<Jenkins, JenkinsList, DoneableJenkins, Resource<Jenkins, DoneableJenkins>> jenkins() {
//    return delegate.jenkins();
//  }
//
//  @Override
//  public MixedOperation<JenkinsBinding, JenkinsBindingList, DoneableJenkinsBinding, Resource<JenkinsBinding, DoneableJenkinsBinding>> jenkinsBindings() {
//    return delegate.jenkinsBindings();
//  }
//
//  @Override
//  public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> load(InputStream is) {
//    return delegate.load(is);
//  }
//
//  @Override
//  public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(KubernetesResourceList is) {
//    return delegate.resourceList(is);
//  }
//
//  @Override
//  public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(HasMetadata... items) {
//    return delegate.resourceList(items);
//  }
//
//  @Override
//  public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(Collection<HasMetadata> items) {
//    return delegate.resourceList(items);
//  }
//
//  @Override
//  public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(String s) {
//    return delegate.resourceList(s);
//  }
//
//  @Override
//  public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(HasMetadata item) {
//    return delegate.resource(item);
//  }
//
//  @Override
//  public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(String s) {
//    return delegate.resource(s);
//  }
//
//  @Override
//  public MixedOperation<Endpoints, EndpointsList, DoneableEndpoints, Resource<Endpoints, DoneableEndpoints>> endpoints() {
//    return delegate.endpoints();
//  }
//
//  @Override
//  public MixedOperation<Event, EventList, DoneableEvent, Resource<Event, DoneableEvent>> events() {
//    return delegate.events();
//  }
//
//  @Override
//  public NonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, Resource<Namespace, DoneableNamespace>> namespaces() {
//    return delegate.namespaces();
//  }
//
//  @Override
//  public NonNamespaceOperation<Node, NodeList, DoneableNode, Resource<Node, DoneableNode>> nodes() {
//    return delegate.nodes();
//  }
//
//  @Override
//  public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, Resource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
//    return delegate.persistentVolumes();
//  }
//
//  @Override
//  public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, Resource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
//    return delegate.persistentVolumeClaims();
//  }
//
//  @Override
//  public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods() {
//    return delegate.pods();
//  }
//
//  @Override
//  public MixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
//    return delegate.replicationControllers();
//  }
//
//  @Override
//  public MixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, Resource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
//    return delegate.resourceQuotas();
//  }
//
//  @Override
//  public MixedOperation<Secret, SecretList, DoneableSecret, Resource<Secret, DoneableSecret>> secrets() {
//    return delegate.secrets();
//  }
//
//  @Override
//  public MixedOperation<StorageClass, StorageClassList, DoneableStorageClass, Resource<StorageClass, DoneableStorageClass>> storageClasses() {
//    return delegate.storageClasses();
//  }
//
//  public MixedOperation<PodSecurityPolicy, PodSecurityPolicyList, DoneablePodSecurityPolicy, Resource<PodSecurityPolicy, DoneablePodSecurityPolicy>> podSecurityPolicies() {
//    return delegate.podSecurityPolicies();
//  }
//
//  @Override
//  public MixedOperation<io.alauda.kubernetes.api.model.Service, ServiceList, DoneableService, Resource<io.alauda.kubernetes.api.model.Service, DoneableService>> services() {
//    return delegate.services();
//  }
//
//  @Override
//  public MixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, Resource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
//    return delegate.serviceAccounts();
//  }
//
//  @Override
//  public KubernetesListMixedOperation lists() {
//    return delegate.lists();
//  }
//
//  @Override
//  public MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> configMaps() {
//    return delegate.configMaps();
//  }
//
//  @Override
//  public MixedOperation<LimitRange, LimitRangeList, DoneableLimitRange, Resource<LimitRange, DoneableLimitRange>> limitRanges() {
//    return delegate.limitRanges();
//  }
//
//  @Override
//  public <T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResources(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
//    return delegate.customResources(crd, resourceType, listClass, doneClass);
//  }
//
//  @Override
//  public <T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResource(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
//    return customResources(crd, resourceType, listClass, doneClass);
//  }
//
//  @Override
//  public NonNamespaceOperation<CustomResourceDefinition, CustomResourceDefinitionList, DoneableCustomResourceDefinition, Resource<CustomResourceDefinition, DoneableCustomResourceDefinition>> customResourceDefinitions() {
//    return delegate.customResourceDefinitions();
//  }
//
//  @Override
//  public <C> C adapt(Class<C> type) {
//    return delegate.adapt(type);
//  }
//
//  @Override
//  public URL getMasterUrl() {
//    return delegate.getMasterUrl();
//  }
//
//  @Override
//  public String getApiVersion() {
//    return delegate.getApiVersion();
//  }
//
//  @Override
//  public String getNamespace() {
//    return delegate.getNamespace();
//  }
//
//  @Override
//  public RootPaths rootPaths() {
//    return delegate.rootPaths();
//  }
//
//  @Override
//  public void close() {
//    delegate.close();
//  }
//
//  @Override
//  public Config getConfiguration() {
//    return delegate.getConfiguration();
//  }
//
//  @Override
//  public ExtensionsAPIGroupDSL extensions() {
//    return delegate.extensions();
//  }
//
//  @Override
//  public AppsAPIGroupDSL apps() {
//    return delegate.apps();
//  }
//
//  @Override
//  public AutoscalingAPIGroupDSL autoscaling() {
//    return delegate.autoscaling();
//  }
//
//  @Override
//  public NamespacedAlaudaDevOpsClient inAnyNamespace() {
//    return delegate.inAnyNamespace();
//  }
//
//  @Override
//  public NamespacedAlaudaDevOpsClient inNamespace(String name) {
//    return delegate.inNamespace(name);
//  }
//
//  @Override
//  public FunctionCallable<NamespacedAlaudaDevOpsClient> withRequestConfig(RequestConfig requestConfig) {
//    return delegate.withRequestConfig(requestConfig);
//  }
//
//  @Override
//  public boolean supportAlaudaAPIGroup(String apiGroup) {
//    return delegate.supportAlaudaAPIGroup(apiGroup);
//  }
//}
