package io.alauda.devops.client.dsl.internal;

import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.kubernetes.api.model.CodeRepository;
import io.alauda.kubernetes.api.model.CodeRepositoryList;
import io.alauda.kubernetes.api.model.DoneableCodeRepository;
import io.alauda.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import java.util.Map;
import java.util.TreeMap;

import static io.alauda.devops.client.AlaudaAPIGroups.DEVOPS;

public class CodeRepositoryOperationsImpl extends AlaudaOperation<CodeRepository,
  CodeRepositoryList, DoneableCodeRepository, Resource<CodeRepository, DoneableCodeRepository>> {
  public CodeRepositoryOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String namespace) {
    this(client, config, null, namespace, null, true, null, null,
      false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(),
      new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
  }

  public CodeRepositoryOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion,
                                      String namespace, String name, Boolean cascading, CodeRepository item,
                                      String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds,
                                      Map<String, String> labels, Map<String, String> labelsNot,
                                      Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
    super(client, AlaudaOperation.withApiGroup(client, DEVOPS, apiVersion, config), "coderepositories",
      namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
  }
}
