package io.alauda.devops.client.models;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.alauda.kubernetes.api.model.ObjectMeta;
import io.alauda.kubernetes.api.model.validators.CheckObjectMeta;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
  "apiVersion",
  "kind",
  "metadata",
  "spec",
  "status"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
public class PipelineConfig {
  @NotNull
  @JsonProperty("apiVersion")
  private String apiVersion = "devops.alauda.io/v1alpha1";
  /**
   *
   * (Required)
   *
   */
  @NotNull
  @JsonProperty("kind")
  private String kind = "PipelineConfig";

  public PipelineConfig(String apiVersion, String kind, ObjectMeta metadata, PipelineConfigSpec spec, PipelineConfigStatus status) {
    this.apiVersion = apiVersion;
    this.kind = kind;
    this.metadata = metadata;
    this.spec = spec;
    this.status = status;
  }

  public PipelineConfig() {
  }

  /**
   *

   *
   */
  @JsonProperty("metadata")
  @Valid
  @CheckObjectMeta(regexp = "^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$", max = 253)
  private ObjectMeta metadata;

  @JsonProperty("spec")
  @Valid
  private PipelineConfigSpec spec;

  @JsonProperty("status")
  @Valid
  private PipelineConfigStatus status;

  @JsonProperty("apiVersion")
  public String getApiVersion() {
    return apiVersion;
  }

  @JsonProperty("apiVersion")
  public void setApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
  }
  @JsonProperty("kind")
  public String getKind() {
    return kind;
  }
  @JsonProperty("kind")
  public void setKind(String kind) {
    this.kind = kind;
  }
  @JsonProperty("metadata")
  public ObjectMeta getMetadata() {
    return metadata;
  }
  @JsonProperty("metadata")
  public void setMetadata(ObjectMeta metadata) {
    this.metadata = metadata;
  }

  @JsonProperty("spec")
  public PipelineConfigSpec getSpec() {
    return spec;
  }

  @JsonProperty("spec")
  public void setSpec(PipelineConfigSpec spec) {
    this.spec = spec;
  }
  @JsonProperty("status")
  public PipelineConfigStatus getStatus() {
    return status;
  }
  @JsonProperty("status")
  public void setStatus(PipelineConfigStatus status) {
    this.status = status;
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }
  @JsonAnySetter
  public void setAdditionalProperties(Map<String, Object> additionalProperties) {
    this.additionalProperties = additionalProperties;
  }

  @JsonIgnore
  private Map<String, Object> additionalProperties = new HashMap<String, Object>();
}
