package io.alauda.devops.client.dsl.internal;

import io.alauda.devops.client.AlaudaAPIGroups;
import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.devops.client.dsl.ClusterPipelineTaskTemplateResource;
import io.alauda.devops.client.dsl.PipelineTaskTemplateResource;
import io.alauda.kubernetes.api.model.*;
import okhttp3.OkHttpClient;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import java.util.TreeMap;

public class ClusterPipelineTaskTemplateOperationsImpl extends AlaudaOperation<ClusterPipelineTaskTemplate, ClusterPipelineTaskTemplateList, DoneableClusterPipelineTaskTemplate, ClusterPipelineTaskTemplateResource<ClusterPipelineTaskTemplate, DoneableClusterPipelineTaskTemplate, Void, ClusterPipelineTaskTemplate>>
  implements ClusterPipelineTaskTemplateResource<ClusterPipelineTaskTemplate, DoneableClusterPipelineTaskTemplate, Void, ClusterPipelineTaskTemplate> {

  private final InputStream in;
  private final OutputStream out;
  private final OutputStream err;

  private final PipedOutputStream inPipe;
  private final PipedInputStream outPipe;
  private final PipedInputStream errPipe;
  private final boolean withTTY;
  private final boolean withTerminatedStatus;
  private final boolean withTimestamps;
  private final String sinceTimestamp;
  private final Integer sinceSeconds;
  private final Integer withTailingLines;
  private final boolean withPrettyOutput;
  private final String version;
  private final Integer limitBytes;

  public ClusterPipelineTaskTemplateOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config) {
    this(client, config, null, null, true, null, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, false, false, false, null, null, null, false, null, null);
  }

  public ClusterPipelineTaskTemplateOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion, String namespace, String name, Boolean cascading, ClusterPipelineTaskTemplate item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
    this(client, config, null, name, cascading, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, false, false, false, null, null, null, false, null, null);
  }

  public ClusterPipelineTaskTemplateOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion, String name, Boolean cascading, ClusterPipelineTaskTemplate item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, InputStream in, OutputStream out, OutputStream err, PipedOutputStream inPipe, PipedInputStream outPipe, PipedInputStream errPipe, boolean withTTY, boolean withTerminatedStatus, boolean withTimestamps, String sinceTimestamp, Integer sinceSeconds, Integer withTailingLines, boolean withPrettyOutput, String version, Integer limitBytes) {
    super(client, AlaudaOperation.withApiGroup(client, AlaudaAPIGroups.DEVOPS, apiVersion, config), "clusterpipelinetasktemplates", null, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
    this.in = in;
    this.out = out;
    this.err = err;
    this.inPipe = inPipe;
    this.outPipe = outPipe;
    this.errPipe = errPipe;
    this.withTTY = withTTY;
    this.withTerminatedStatus = withTerminatedStatus;
    this.withTimestamps = withTimestamps;
    this.sinceTimestamp = sinceTimestamp;
    this.sinceSeconds = sinceSeconds;
    this.withTailingLines = withTailingLines;
    this.withPrettyOutput = withPrettyOutput;
    this.version = version;
    this.limitBytes = limitBytes;
  }

  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
