/**
 * Copyright (C) 2018 Alauda
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.alauda.devops.client;

import java.net.URL;

import io.alauda.devops.client.dsl.*;
import io.alauda.kubernetes.api.model.*;
import io.alauda.kubernetes.client.KubernetesClient;
import io.alauda.kubernetes.client.dsl.*;

public interface AlaudaDevOpsClient extends KubernetesClient {

  URL getKubernetesUrl();

  ExtensionsAPIGroupDSL extensions();

  AppsAPIGroupDSL apps();

  AutoscalingAPIGroupDSL autoscaling();

//  MixedOperation<Build, BuildList, DoneableBuild, BuildResource<Build, DoneableBuild, String, LogWatch>> builds();
//
//  MixedOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, BuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build>> buildConfigs();

  MixedOperation<Pipeline, PipelineList, DoneablePipeline, PipelineResource<Pipeline, DoneablePipeline, String, LogWatch>> pipelines();

  MixedOperation<PipelineConfig, PipelineConfigList, DoneablePipelineConfig, PipelineConfigResource<PipelineConfig, DoneablePipelineConfig, Void, Pipeline>> pipelineConfigs();

  MixedOperation<PipelineTemplate, PipelineTemplateList, DoneablePipelineTemplate, PipelineTemplateResource<PipelineTemplate, DoneablePipelineTemplate, Void, PipelineTemplate>> pipelinetemplates();

  MixedOperation<PipelineTaskTemplate, PipelineTaskTemplateList, DoneablePipelineTaskTemplate, PipelineTaskTemplateResource<PipelineTaskTemplate, DoneablePipelineTaskTemplate, Void, PipelineTaskTemplate>> pipelinetasktemplates();

  NonNamespaceOperation<ClusterPipelineTemplate, ClusterPipelineTemplateList, DoneableClusterPipelineTemplate, ClusterPipelineTemplateResource<ClusterPipelineTemplate, DoneableClusterPipelineTemplate, Void, ClusterPipelineTemplate>> clusterPipelinetemplates();

  NonNamespaceOperation<ClusterPipelineTaskTemplate, ClusterPipelineTaskTemplateList, DoneableClusterPipelineTaskTemplate, ClusterPipelineTaskTemplateResource<ClusterPipelineTaskTemplate, DoneableClusterPipelineTaskTemplate, Void, ClusterPipelineTaskTemplate>> clusterPipelinetasktemplates();

//  MixedOperation<DeploymentConfig, DeploymentConfigList, DoneableDeploymentConfig, DeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig>> deploymentConfigs();
//
//  NonNamespaceOperation<Group, GroupList, DoneableGroup, Resource<Group, DoneableGroup>> groups();
//
//  MixedOperation<ImageStream, ImageStreamList, DoneableImageStream, Resource<ImageStream, DoneableImageStream>> imageStreams();
//
//  MixedOperation<ImageStreamTag, ImageStreamTagList, DoneableImageStreamTag, Resource<ImageStreamTag, DoneableImageStreamTag>> imageStreamTags();
//
//  NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, DoneableOAuthAccessToken, Resource<OAuthAccessToken, DoneableOAuthAccessToken>> oAuthAccessTokens();
//
//  NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, DoneableOAuthAuthorizeToken, Resource<OAuthAuthorizeToken, DoneableOAuthAuthorizeToken>> oAuthAuthorizeTokens();
//
//  NonNamespaceOperation<OAuthClient, OAuthClientList, DoneableOAuthClient, Resource<OAuthClient, DoneableOAuthClient>> oAuthClients();
//
//  MixedOperation<Policy, PolicyList, DoneablePolicy, Resource<Policy, DoneablePolicy>> policies();
//
//  MixedOperation<PolicyBinding, PolicyBindingList, DoneablePolicyBinding, Resource<PolicyBinding, DoneablePolicyBinding>> policyBindings();

  NonNamespaceOperation<Project, ProjectList, DoneableProject, Resource<Project, DoneableProject>> projects();

  NonNamespaceOperation<Jenkins, JenkinsList, DoneableJenkins, Resource<Jenkins, DoneableJenkins>> jenkins();

  MixedOperation<JenkinsBinding, JenkinsBindingList, DoneableJenkinsBinding, Resource<JenkinsBinding, DoneableJenkinsBinding>> jenkinsBindings();

//  MixedOperation<Role, RoleList, DoneableRole, Resource<Role, DoneableRole>> roles();
//
//  MixedOperation<RoleBinding, RoleBindingList, DoneableRoleBinding, Resource<RoleBinding, DoneableRoleBinding>>
//  roleBindings();
//
//  MixedOperation<Route, RouteList, DoneableRoute, Resource<Route, DoneableRoute>> routes();
//
//  ParameterMixedOperation<Template, TemplateList, DoneableTemplate, TemplateResource<Template, KubernetesList, DoneableTemplate>> templates();
//
//  NonNamespaceOperation<User, UserList, DoneableUser, Resource<User, DoneableUser>> users();

//  SubjectAccessReviewOperation<CreateableSubjectAccessReview, CreateableLocalSubjectAccessReview> subjectAccessReviews();

//  MixedOperation<ClusterRoleBinding, ClusterRoleBindingList, DoneableClusterRoleBinding, Resource<ClusterRoleBinding, DoneableClusterRoleBinding>> clusterRoleBindings();


  /**
   * Returns true if this cluster is a legacy devops cluster or supports the given OpenShift API Group defined in {@link AlaudaAPIGroups}
   */
  boolean supportAlaudaAPIGroup(String apiGroup);
}
