package io.alauda.devops.client.dsl.internal;

import io.alauda.devops.client.AlaudaAPIGroups;
import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.devops.client.dsl.PipelineTemplateResource;
import io.alauda.kubernetes.api.model.*;
import io.alauda.kubernetes.client.KubernetesClientException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;

public class PipelineTemplateOperationsImpl extends AlaudaOperation<PipelineTemplate, PipelineTemplateList,
  DoneablePipelineTemplate, PipelineTemplateResource<PipelineTemplate, DoneablePipelineTemplate, Void, PipelineTemplate>>
  implements PipelineTemplateResource<PipelineTemplate, DoneablePipelineTemplate, Void, PipelineTemplate> {

  private final InputStream in;
  private final OutputStream out;
  private final OutputStream err;

  private final PipedOutputStream inPipe;
  private final PipedInputStream outPipe;
  private final PipedInputStream errPipe;
  private final boolean withTTY;
  private final boolean withTerminatedStatus;
  private final boolean withTimestamps;
  private final String sinceTimestamp;
  private final Integer sinceSeconds;
  private final Integer withTailingLines;
  private final boolean withPrettyOutput;
  private final String version;
  private final Integer limitBytes;

  public PipelineTemplateOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String namespace) {
    this(client, config, null, namespace, null, true, null, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, false, false, false, null, null, null, false, null, null);
  }

  public PipelineTemplateOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion, String namespace, String name, Boolean cascading, PipelineTemplate item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
    this(client, config, null, namespace, name, cascading, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, false, false, false, null, null, null, false, null, null);
  }

  public PipelineTemplateOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion, String namespace, String name, Boolean cascading, PipelineTemplate item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, InputStream in, OutputStream out, OutputStream err, PipedOutputStream inPipe, PipedInputStream outPipe, PipedInputStream errPipe, boolean withTTY, boolean withTerminatedStatus, boolean withTimestamps, String sinceTimestamp, Integer sinceSeconds, Integer withTailingLines, boolean withPrettyOutput, String version, Integer limitBytes) {
    super(client, AlaudaOperation.withApiGroup(client, AlaudaAPIGroups.DEVOPS, apiVersion, config), "pipelinetemplates", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
    this.in = in;
    this.out = out;
    this.err = err;
    this.inPipe = inPipe;
    this.outPipe = outPipe;
    this.errPipe = errPipe;
    this.withTTY = withTTY;
    this.withTerminatedStatus = withTerminatedStatus;
    this.withTimestamps = withTimestamps;
    this.sinceTimestamp = sinceTimestamp;
    this.sinceSeconds = sinceSeconds;
    this.withTailingLines = withTailingLines;
    this.withPrettyOutput = withPrettyOutput;
    this.version = version;
    this.limitBytes = limitBytes;
  }

  @Override
  public JenkinsfilePreview preview(JenkinsfilePreviewOptions options) {
    try {
      return handleCreate(options, JenkinsfilePreview.class);
    } catch (ExecutionException e) {
      e.printStackTrace();
    } catch (InterruptedException e) {
      e.printStackTrace();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return null;
  }

  @Override
  protected <T, I> T handleCreate(I resource, Class<T> outputType) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
    RequestBody body = RequestBody.create(JSON, JSON_MAPPER.writeValueAsString(resource));
    URL url = getNamespacedUrl(checkNamespace(resource));
    if(resource instanceof JenkinsfilePreviewOptions) {
      url = new URL(url, url.getPath() + "/" + this.getName() + "/preview");
    }

    Request.Builder requestBuilder = new Request.Builder().post(body).url(url);
    return handleResponse(requestBuilder, outputType, Collections.<String, String>emptyMap());
  }

//  @Override
//  public URL getNamespacedUrl(String namespace) throws MalformedURLException {
//    URL url = super.getNamespacedUrl(namespace);
//    return url;
//  }

//  @Override
//  protected <T> String checkNamespace(T item) {
//    String url = super.checkNamespace(item);
//    if(item instanceof JenkinsfilePreviewOptions) {
//      url += "/preview";
//    }
//    return url;
//  }
}
