/**
 * Copyright (C) 2018 Alauda
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.alauda.devops.client;

import okhttp3.OkHttpClient;
import io.alauda.kubernetes.client.Client;
import io.alauda.kubernetes.client.ExtensionAdapter;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

@Component
@Service
public class AlaudaDevOpsExtensionAdapter extends AlaudaDevOpsAdapterSupport implements ExtensionAdapter<AlaudaDevOpsClient> {

  @Override
  public Class<AlaudaDevOpsClient> getExtensionType() {
    return AlaudaDevOpsClient.class;
  }


  @Override
  public AlaudaDevOpsClient adapt(Client client) {
    if (!isAdaptable(client)) {
      throw new AlaudaDevOpsNotAvailableException("Alauda Devops is not available. Root paths at: " + client.getMasterUrl() + " do not include *.alauda.io apis.");
    }
    return new DefaultAlaudaDevOpsClient(client.adapt(OkHttpClient.class), AlaudaDevOpsConfig.wrap(client.getConfiguration()));
  }
}
