/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.client.dsl.internal;

import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.devops.client.dsl.CreateableLocalSubjectAccessReview;
import io.alauda.devops.client.dsl.CreateableSubjectAccessReview;
import io.alauda.devops.client.dsl.SubjectAccessReviewOperation;
import io.alauda.devops.client.dsl.internal.AlaudaOperation;
import io.alauda.kubernetes.api.model.HasMetadata;
import io.alauda.kubernetes.client.KubernetesClientException;
import io.alauda.kubernetes.client.dsl.base.OperationSupport;
import io.alauda.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.LocalSubjectAccessReviewBuilder;
import io.fabric8.openshift.api.model.LocalSubjectAccessReviewFluent;
import io.fabric8.openshift.api.model.SubjectAccessReview;
import io.fabric8.openshift.api.model.SubjectAccessReviewBuilder;
import io.fabric8.openshift.api.model.SubjectAccessReviewFluent;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import okhttp3.OkHttpClient;

public class SubjectAccessReviewOperationImpl
extends OperationSupport
implements SubjectAccessReviewOperation<CreateableSubjectAccessReview, CreateableLocalSubjectAccessReview> {
    public SubjectAccessReviewOperationImpl(OkHttpClient client, AlaudaDevOpsConfig config) {
        this(client, config, null, null);
    }

    public SubjectAccessReviewOperationImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion, String namespace) {
        super(client, AlaudaOperation.withApiGroup(client, "authorization.devops.io", apiVersion, config), "subjectaccessreviews", namespace, null);
    }

    public CreateableLocalSubjectAccessReview inNamespace(String namespace) {
        return new SubjectAccessReviewOperationImpl(this.client, AlaudaDevOpsConfig.wrap(this.getConfig()), null, namespace).local();
    }

    public SubjectAccessReviewResponse create(SubjectAccessReview ... item) {
        return new CreateableSubjectAccessReviewImpl(this.client).create(item);
    }

    public CreateableSubjectAccessReview createNew() {
        return new CreateableSubjectAccessReviewImpl(this.client).createNew();
    }

    public URL getRootUrl() {
        try {
            return new URL(AlaudaDevOpsConfig.wrap(this.getConfig()).getKubernetesUrl());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    private CreateableLocalSubjectAccessReview local() {
        return new CreateableLocalSubjectAccessReviewImpl(this.client);
    }

    protected <T> String checkNamespace(T item) {
        String itemNs;
        String operationNs = this.getNamespace();
        String string = itemNs = item instanceof HasMetadata && ((HasMetadata)item).getMetadata() != null ? ((HasMetadata)item).getMetadata().getNamespace() : null;
        if (Utils.isNullOrEmpty((String)operationNs) && Utils.isNullOrEmpty(itemNs)) {
            return null;
        }
        if (Utils.isNullOrEmpty(itemNs)) {
            return operationNs;
        }
        if (Utils.isNullOrEmpty((String)operationNs)) {
            return itemNs;
        }
        if (itemNs.equals(operationNs)) {
            return itemNs;
        }
        throw new KubernetesClientException("Namespace mismatch. Item namespace:" + itemNs + ". Operation namespace:" + operationNs + ".");
    }

    private class CreateableSubjectAccessReviewImpl
    extends CreateableSubjectAccessReview {
        private final OkHttpClient client;
        private final SubjectAccessReviewBuilder builder;

        private CreateableSubjectAccessReviewImpl(OkHttpClient client) {
            this.client = client;
            this.builder = new SubjectAccessReviewBuilder((SubjectAccessReviewFluent)this);
        }

        private CreateableSubjectAccessReviewImpl(OkHttpClient client, SubjectAccessReviewBuilder builder) {
            this.client = client;
            this.builder = builder;
        }

        public SubjectAccessReviewResponse create(SubjectAccessReview ... resources) {
            try {
                if (resources.length > 1) {
                    throw new IllegalArgumentException("Too many items to create.");
                }
                if (resources.length == 1) {
                    return (SubjectAccessReviewResponse)SubjectAccessReviewOperationImpl.this.handleCreate(resources[0], SubjectAccessReviewResponse.class);
                }
                throw new IllegalArgumentException("Nothing to create.");
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw KubernetesClientException.launderThrowable((Throwable)e);
            }
        }

        public CreateableSubjectAccessReview createNew() {
            return this;
        }

        public SubjectAccessReviewResponse done() {
            return this.create(this.builder.build());
        }
    }

    private class CreateableLocalSubjectAccessReviewImpl
    extends CreateableLocalSubjectAccessReview {
        private final OkHttpClient client;
        private final LocalSubjectAccessReviewBuilder builder;

        private CreateableLocalSubjectAccessReviewImpl(OkHttpClient client) {
            this.client = client;
            this.builder = new LocalSubjectAccessReviewBuilder((LocalSubjectAccessReviewFluent)this);
        }

        private CreateableLocalSubjectAccessReviewImpl(OkHttpClient client, LocalSubjectAccessReviewBuilder builder) {
            this.client = client;
            this.builder = builder;
        }

        public SubjectAccessReviewResponse create(LocalSubjectAccessReview ... resources) {
            try {
                if (resources.length > 1) {
                    throw new IllegalArgumentException("Too many items to create.");
                }
                if (resources.length == 1) {
                    return (SubjectAccessReviewResponse)SubjectAccessReviewOperationImpl.this.handleCreate(resources[0], SubjectAccessReviewResponse.class);
                }
                throw new IllegalArgumentException("Nothing to create.");
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw KubernetesClientException.launderThrowable((Throwable)e);
            }
        }

        public CreateableLocalSubjectAccessReview createNew() {
            return this;
        }

        public SubjectAccessReviewResponse done() {
            return this.create(this.builder.build());
        }
    }
}

