/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.client;

import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.kubernetes.api.model.DoneableJenkins;
import io.alauda.kubernetes.api.model.Jenkins;
import io.alauda.kubernetes.api.model.JenkinsFluent;
import io.alauda.kubernetes.api.model.JenkinsList;
import io.alauda.kubernetes.client.Config;
import io.alauda.kubernetes.client.ConfigBuilder;
import io.alauda.kubernetes.client.DefaultKubernetesClient;
import io.alauda.kubernetes.client.dsl.Resource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsTest {
    private static final Logger logger = LoggerFactory.getLogger(JenkinsTest.class);
    private AlaudaDevOpsClient client;

    public static Jenkins createJenkins(AlaudaDevOpsClient client, String name, String host) {
        return ((DoneableJenkins)((JenkinsFluent.SpecNested)((DoneableJenkins)((JenkinsFluent.MetadataNested)((DoneableJenkins)client.jenkins().createNew()).withNewMetadata().withName(name)).endMetadata()).withNewSpec().withNewHttp(host)).endSpec()).done();
    }

    @Before
    public void before() {
        Config config = new ConfigBuilder().build();
        DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient(config);
        this.client = (AlaudaDevOpsClient)kubernetesClient.adapt(AlaudaDevOpsClient.class);
    }

    @After
    public void after() {
        if (this.client != null) {
            this.client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="Needs real access to the API server")
    public void testCreateGetUpdateDelete() {
        String host = "http://baidu.com";
        String newHost = "http://www.google.com";
        String name = "my-test-jenkins";
        try {
            Jenkins jenkins = JenkinsTest.createJenkins(this.client, name, host);
            Assert.assertNotNull((Object)jenkins);
            JenkinsTest.log("Created jenkins", jenkins);
            JenkinsList list = (JenkinsList)this.client.jenkins().list();
            Assert.assertNotNull((Object)list);
            Assert.assertNotNull((Object)list.getItems());
            Assert.assertTrue((boolean)list.getItems().contains(jenkins));
            Jenkins serverVer = (Jenkins)((Resource)this.client.jenkins().withName(name)).get();
            Assert.assertNotNull((Object)serverVer);
            Assert.assertEquals((Object)jenkins, (Object)serverVer);
            jenkins.getSpec().getHttp().setHost(newHost);
            jenkins = (Jenkins)this.client.jenkins().createOrReplace((Object[])new Jenkins[]{jenkins});
            Assert.assertNotNull((Object)jenkins);
            serverVer = (Jenkins)((Resource)this.client.jenkins().withName(name)).get();
            Assert.assertEquals((Object)newHost, (Object)serverVer.getSpec().getHttp().getHost());
            Assert.assertEquals((Object)serverVer.getSpec().getHttp().getHost(), (Object)jenkins.getSpec().getHttp().getHost());
            JenkinsTest.log("Done.");
        }
        finally {
            JenkinsTest.log("delete", ((Resource)this.client.jenkins().withName(name)).delete());
        }
    }

    private static void log(String action, Object obj) {
        logger.error("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.error(action);
    }
}

