package io.alauda.devops.client.models;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.alauda.kubernetes.api.model.Doneable;
import io.alauda.kubernetes.api.model.KubernetesResource;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.annotation.Generated;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
  "apiVersion",
  "kind",
  "metadata",
  "successCount",
  "failureCount"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(builderPackage = "io.alauda.kubernetes.api.builder",validationEnabled = true, editableEnabled = false, inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class PipelineRunLimits implements KubernetesResource {
  @JsonProperty("successCount")
  private Long successCount;
  @JsonProperty("failureCount")
  private Long failureCount;
  @JsonIgnore
  private Map<String, Object> additionalProperties = new HashMap<String, Object>();

  public PipelineRunLimits(Long successCount, Long failureCount) {
    this.successCount = successCount;
    this.failureCount = failureCount;
  }

  public PipelineRunLimits() {
  }


  @JsonProperty("successCount")
  public Long getSuccessCount() {
    return successCount;
  }
  @JsonProperty("successCount")
  public void setSuccessCount(Long successCount) {
    this.successCount = successCount;
  }
  @JsonProperty("failureCount")
  public Long getFailureCount() {
    return failureCount;
  }
  @JsonProperty("failureCount")
  public void setFailureCount(Long failureCount) {
    this.failureCount = failureCount;
  }
  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }
  @JsonAnySetter
  public void setAdditionalProperties(Map<String, Object> additionalProperties) {
    this.additionalProperties = additionalProperties;
  }


}

