/**
 * Copyright (C) 2018 Alauda
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.alauda.devops.client.handlers;

import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.kubernetes.client.*;
import okhttp3.OkHttpClient;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

import io.alauda.kubernetes.api.model.Pipeline;
import io.alauda.kubernetes.api.model.PipelineBuilder;
import io.alauda.devops.client.dsl.internal.PipelineOperationsImpl;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

@Component
@Service
public class PipelineHandler implements ResourceHandler<Pipeline, PipelineBuilder> {

  @Override
  public String getKind() {
    return Pipeline.class.getSimpleName();
  }

  @Override
  public Pipeline create(OkHttpClient client, Config config, String namespace, Pipeline item) {
    return new PipelineOperationsImpl(client, AlaudaDevOpsConfig.wrap(config), null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, false, false, false, null, -1, -1, false, null, null).create();
  }

  @Override
  public Pipeline replace(OkHttpClient client, Config config, String namespace, Pipeline item) {
    return new PipelineOperationsImpl(client, AlaudaDevOpsConfig.wrap(config), null, namespace, null, true, item, null, true, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, false, false, false, null, -1, -1, false, null, null).replace(item);
  }

  @Override
  public Pipeline reload(OkHttpClient client, Config config, String namespace, Pipeline item) {
    return new PipelineOperationsImpl(client, AlaudaDevOpsConfig.wrap(config), null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, false, false, false, null, -1, -1, false, null, null).fromServer().get();
  }

  @Override
  public PipelineBuilder edit(Pipeline item) {
    return new PipelineBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, Pipeline item) {
    return new PipelineOperationsImpl(client, AlaudaDevOpsConfig.wrap(config), null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, false, false, false, null, -1, -1, false, null, null).delete(item);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Pipeline item, Watcher<Pipeline> watcher) {
    return new PipelineOperationsImpl(client, AlaudaDevOpsConfig.wrap(config), null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, false, false, false, null, -1, -1, false, null, null).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Pipeline item, String resourceVersion, Watcher<Pipeline> watcher) {
    return new PipelineOperationsImpl(client, AlaudaDevOpsConfig.wrap(config), null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, false, false, false, null, -1, -1, false, null, null).watch(resourceVersion, watcher);
  }

  @Override
  public Pipeline waitUntilReady(OkHttpClient client, Config config, String namespace, Pipeline item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PipelineOperationsImpl(client, AlaudaDevOpsConfig.wrap(config), null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, false, false, false, null, -1, -1, false, null, null).waitUntilReady(amount, timeUnit);
  }
}
