/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.client.dsl.internal;

import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.devops.client.dsl.PipelineConfigOperation;
import io.alauda.devops.client.dsl.PipelineConfigResource;
import io.alauda.devops.client.dsl.PipelineResource;
import io.alauda.devops.client.dsl.internal.AlaudaOperation;
import io.alauda.devops.client.dsl.internal.PipelineOperationsImpl;
import io.alauda.kubernetes.api.model.DoneablePipelineConfig;
import io.alauda.kubernetes.api.model.Pipeline;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.api.model.PipelineConfigList;
import io.alauda.kubernetes.api.model.PipelineList;
import io.alauda.kubernetes.client.KubernetesClientException;
import io.alauda.kubernetes.client.Watch;
import io.alauda.kubernetes.client.Watcher;
import io.alauda.kubernetes.client.dsl.Gettable;
import io.alauda.kubernetes.client.dsl.Reaper;
import io.alauda.kubernetes.client.dsl.Watchable;
import io.alauda.kubernetes.client.utils.URLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class PipelineConfigOperationsImpl
extends AlaudaOperation<PipelineConfig, PipelineConfigList, DoneablePipelineConfig, PipelineConfigResource<PipelineConfig, DoneablePipelineConfig, Void, Pipeline>>
implements PipelineConfigOperation {
    public static final String PIPELINE_CONFIG_LABEL = "pipelineConfig";
    public static final String PIPELINE_CONFIG_ANNOTATION = "alauda.io/pipelineConfig.name";
    private final String secret;
    private final String triggerType;
    private final String authorName;
    private final String authorEmail;
    private final String committerName;
    private final String committerEmail;
    private final String commit;
    private final String message;
    private final String asFile;
    private final long timeout;
    private final TimeUnit timeoutUnit;

    public PipelineConfigOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String namespace) {
        this(client, config, null, namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, null, null, null, config.getBuildTimeout(), TimeUnit.MILLISECONDS);
    }

    public PipelineConfigOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion, String namespace, String name, Boolean cascading, PipelineConfig item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        this(client, config, null, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields, null, null, null, null, null, null, null, null, null, config.getBuildTimeout(), TimeUnit.MILLISECONDS);
    }

    public PipelineConfigOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion, String namespace, String name, Boolean cascading, PipelineConfig item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, String secret, String triggerType, String authorName, String authorEmail, String committerName, String committerEmail, String commit, String message, String asFile, long timeout, TimeUnit timeoutUnit) {
        super(client, AlaudaOperation.withApiGroup(client, "devops.alauda.io", apiVersion, config), "pipelineconfigs", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.triggerType = triggerType;
        this.secret = secret;
        this.authorName = authorName;
        this.authorEmail = authorEmail;
        this.committerName = committerName;
        this.committerEmail = committerEmail;
        this.commit = commit;
        this.message = message;
        this.asFile = asFile;
        this.reaper = new PipelineConfigReaper(this);
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
    }

    public PipelineConfigResource<PipelineConfig, DoneablePipelineConfig, Void, Pipeline> withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        return new PipelineConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), name, this.isCascading(), (PipelineConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, this.message, this.asFile, this.timeout, this.timeoutUnit);
    }

    @Override
    public AlaudaOperation<PipelineConfig, PipelineConfigList, DoneablePipelineConfig, PipelineConfigResource<PipelineConfig, DoneablePipelineConfig, Void, Pipeline>> inNamespace(String namespace) {
        return new PipelineConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), namespace, this.getName(), this.isCascading(), (PipelineConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, this.message, this.asFile, this.timeout, this.timeoutUnit);
    }

    public Gettable<PipelineConfig> fromServer() {
        return new PipelineConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (PipelineConfig)this.getItem(), this.getResourceVersion(), true, this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, this.message, this.asFile, this.timeout, this.timeoutUnit);
    }

    public PipelineConfigResource<PipelineConfig, DoneablePipelineConfig, Void, Pipeline> load(InputStream is) {
        return new PipelineConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (PipelineConfig)PipelineConfigOperationsImpl.unmarshal((InputStream)is, (Class)this.getType()), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, this.message, this.asFile, this.timeout, this.timeoutUnit);
    }

    public Watchable<Watch, Watcher<PipelineConfig>> withResourceVersion(String resourceVersion) {
        PipelineConfigOperationsImpl pipelineConfigOperations = new PipelineConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (PipelineConfig)this.getItem(), resourceVersion, this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, this.message, this.asFile, this.timeout, this.timeoutUnit);
        return pipelineConfigOperations;
    }

    private void deletePipelines() {
        if (this.getName() == null) {
            return;
        }
        String pipelineConfigLabelValue = this.getName().substring(0, Math.min(this.getName().length(), 63));
        PipelineList matchingPipelines = (PipelineList)new PipelineOperationsImpl(this.client, (AlaudaDevOpsConfig)this.config, this.namespace).inNamespace(this.namespace).withLabel(PIPELINE_CONFIG_LABEL, pipelineConfigLabelValue).list();
        if (matchingPipelines.getItems() != null) {
            for (Pipeline matchingPipeline : matchingPipelines.getItems()) {
                if (matchingPipeline.getMetadata() == null || matchingPipeline.getMetadata().getAnnotations() == null || !this.getName().equals(matchingPipeline.getMetadata().getAnnotations().get(PIPELINE_CONFIG_ANNOTATION))) continue;
                ((PipelineResource)new PipelineOperationsImpl(this.client, (AlaudaDevOpsConfig)this.config, this.namespace).inNamespace(matchingPipeline.getMetadata().getNamespace()).withName(matchingPipeline.getMetadata().getName())).delete();
            }
        }
    }

    private Pipeline fromInputStream(final InputStream inputStream, final long contentLength) {
        try {
            RequestBody requestBody = new RequestBody(){

                public MediaType contentType() {
                    return MediaType.parse((String)"application/octet-stream");
                }

                public long contentLength() throws IOException {
                    return contentLength;
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    Source source = null;
                    try {
                        source = Okio.source((InputStream)inputStream);
                        OutputStream os = sink.outputStream();
                        sink.writeAll(source);
                    }
                    catch (IOException e) {
                        throw KubernetesClientException.launderThrowable((String)"Can't instantiate binary build, due to error reading/writing stream. Can be caused if the output stream was closed by the server.", (Throwable)e);
                    }
                }
            };
            OkHttpClient newClient = this.client.newBuilder().readTimeout(this.timeout, this.timeoutUnit).writeTimeout(this.timeout, this.timeoutUnit).build();
            Request.Builder requestBuilder = new Request.Builder().post(requestBody).header("Expect", "100-continue").url(this.getQueryParameters());
            return (Pipeline)this.handleResponse(newClient, requestBuilder, Pipeline.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    private String getQueryParameters() throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        sb.append(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "instantiatebinary"}));
        return sb.toString();
    }

    private static class PipelineConfigReaper
    implements Reaper {
        private PipelineConfigOperationsImpl oper;

        public PipelineConfigReaper(PipelineConfigOperationsImpl oper) {
            this.oper = oper;
        }

        public boolean reap() {
            return false;
        }
    }
}

