/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.client;

import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.kubernetes.api.model.RootPaths;
import io.alauda.kubernetes.client.Client;
import io.alauda.kubernetes.client.Config;
import io.alauda.kubernetes.client.KubernetesClientException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AlaudaDevOpsAdapterSupport {
    static final ConcurrentMap<URL, Boolean> IS_ALAUDA_KUBERNETES = new ConcurrentHashMap<URL, Boolean>();
    static final ConcurrentMap<URL, Boolean> USES_ALAUDA_APIGROUPS = new ConcurrentHashMap<URL, Boolean>();

    public Boolean isAdaptable(Client client) {
        AlaudaDevOpsConfig config = new AlaudaDevOpsConfig(client.getConfiguration());
        if (!AlaudaDevOpsAdapterSupport.hasCustomKubernetesUrl(config) && !AlaudaDevOpsAdapterSupport.isAlaudaKubernetes(client)) {
            return false;
        }
        return true;
    }

    static boolean isAlaudaKubernetes(Client client) {
        List paths;
        URL masterUrl = client.getMasterUrl();
        if (IS_ALAUDA_KUBERNETES.containsKey(masterUrl)) {
            return (Boolean)IS_ALAUDA_KUBERNETES.get(masterUrl);
        }
        RootPaths rootPaths = client.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!path.endsWith(".alauda.io") && !path.contains(".alauda.io/")) continue;
                USES_ALAUDA_APIGROUPS.putIfAbsent(masterUrl, true);
                IS_ALAUDA_KUBERNETES.putIfAbsent(masterUrl, true);
                return true;
            }
        }
        IS_ALAUDA_KUBERNETES.putIfAbsent(masterUrl, false);
        return false;
    }

    static boolean isAlaudaAPIGroups(Client client) {
        AlaudaDevOpsConfig alaudaDevOpsConfig;
        Config configuration = client.getConfiguration();
        if (configuration instanceof AlaudaDevOpsConfig && (alaudaDevOpsConfig = (AlaudaDevOpsConfig)configuration).isDisableApiGroupCheck()) {
            return false;
        }
        URL masterUrl = client.getMasterUrl();
        if (AlaudaDevOpsAdapterSupport.isAlaudaKubernetes(client) && USES_ALAUDA_APIGROUPS.containsKey(masterUrl)) {
            return (Boolean)USES_ALAUDA_APIGROUPS.get(masterUrl);
        }
        return false;
    }

    static boolean hasCustomKubernetesUrl(AlaudaDevOpsConfig config) {
        try {
            URI masterUri = new URI(config.getMasterUrl()).resolve("/");
            URI kubernetesUri = new URI(config.getKubernetesUrl()).resolve("/");
            return !masterUri.equals(kubernetesUri);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }
}

