/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.client;

import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.devops.client.PipelineConfigTest;
import io.alauda.devops.client.dsl.PipelineConfigResource;
import io.alauda.devops.client.dsl.PipelineResource;
import io.alauda.kubernetes.api.model.DoneablePipeline;
import io.alauda.kubernetes.api.model.Pipeline;
import io.alauda.kubernetes.api.model.PipelineCause;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.api.model.PipelineFluent;
import io.alauda.kubernetes.api.model.PipelineList;
import io.alauda.kubernetes.api.model.PipelineSourceFluent;
import io.alauda.kubernetes.api.model.PipelineSpecFluent;
import io.alauda.kubernetes.api.model.PipelineStatusBuilder;
import io.alauda.kubernetes.api.model.PipelineStatusFluent;
import io.alauda.kubernetes.api.model.PipelineStrategyFluent;
import io.alauda.kubernetes.api.model.PipelineTriggerFluent;
import io.alauda.kubernetes.client.Config;
import io.alauda.kubernetes.client.ConfigBuilder;
import io.alauda.kubernetes.client.DefaultKubernetesClient;
import io.alauda.kubernetes.client.dsl.FilterWatchListDeletable;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineTest {
    private static final Logger logger = LoggerFactory.getLogger(PipelineTest.class);
    private AlaudaDevOpsClient client;
    private PipelineConfig pipelineConfig;
    private String namespace = "default-1";
    private String pipelineConfigName = "pipeline-pipeline-config-1";
    private String jenkinsBinding = "jenkins-dev-1";

    @Before
    public void before() {
        Config config = new ConfigBuilder().build();
        DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient(config);
        this.client = (AlaudaDevOpsClient)kubernetesClient.adapt(AlaudaDevOpsClient.class);
        this.pipelineConfig = PipelineConfigTest.createPipelineConfig(this.client, this.namespace, this.pipelineConfigName, this.jenkinsBinding);
        PipelineTest.log("before: new pipelineconfig: " + this.pipelineConfig.getMetadata().getName());
    }

    @After
    public void after() {
        if (this.client != null) {
            PipelineTest.log("after: delete pipelineconfig: " + ((PipelineConfigResource)((NonNamespaceOperation)this.client.pipelineConfigs().inNamespace(this.namespace)).withName(this.pipelineConfigName)).delete());
            this.client.close();
        }
    }

    public Pipeline createBasicPipeline(String name) {
        return ((DoneablePipeline)((PipelineFluent.SpecNested)((PipelineSpecFluent.SourceNested)((PipelineSourceFluent.GitNested)((PipelineSourceFluent.GitNested)((PipelineFluent.SpecNested)((PipelineSpecFluent.StrategyNested)((PipelineStrategyFluent.JenkinsNested)((PipelineFluent.SpecNested)((PipelineSpecFluent.TriggersNested)((PipelineTriggerFluent.CronNested)((PipelineTriggerFluent.CronNested)((PipelineSpecFluent.TriggersNested)((PipelineFluent.SpecNested)((PipelineFluent.SpecNested)((PipelineSpecFluent.PipelineConfigNested)((PipelineFluent.SpecNested)((PipelineSpecFluent.JenkinsBindingNested)((DoneablePipeline)((PipelineFluent.MetadataNested)((PipelineFluent.MetadataNested)((DoneablePipeline)((NonNamespaceOperation)this.client.pipelines().inNamespace(this.namespace)).createNew()).withNewMetadata().withName(name)).withNamespace(this.namespace)).endMetadata()).withNewSpec().withNewJenkinsBinding().withName(this.jenkinsBinding)).endJenkinsBinding()).withNewPipelineConfig().withName(this.pipelineConfigName)).endPipelineConfig()).withRunPolicy("Serial")).addNewTrigger().withType("cron")).withNewCron().withEnabled(Boolean.valueOf(true))).withRule("* * * * *")).endCron()).endTrigger()).withNewStrategy().withNewJenkins().withJenkinsfilePath("Jenkinsfile")).endJenkins()).endStrategy()).withNewSource().withNewGit().withUri("https://github.com/alauda/alauda")).withRef("master")).endGit()).endSource()).endSpec()).done();
    }

    @Test
    @Ignore(value="Needs real access to the API server")
    public void testCreateGetUpdateDelete() {
        Assert.assertNotNull((Object)this.pipelineConfig);
        Pipeline pipeline = this.createBasicPipeline("aaa");
        Assert.assertNotNull((Object)pipeline);
        PipelineTest.log("Created pipeline", pipeline);
        PipelineList list = (PipelineList)((NonNamespaceOperation)this.client.pipelines().inNamespace(this.namespace)).list();
        Assert.assertNotNull((Object)list);
        Assert.assertNotNull((Object)list.getItems());
        Assert.assertEquals((long)1L, (long)list.getItems().size());
        PipelineTest.log("list", list);
        Pipeline serverVersion = (Pipeline)((PipelineResource)((NonNamespaceOperation)this.client.pipelines().inNamespace(this.namespace)).withName(pipeline.getMetadata().getName())).get();
        PipelineTest.log("retrieve from server", serverVersion);
        Assert.assertNotNull((Object)serverVersion);
        Assert.assertEquals((Object)pipeline.getMetadata().getResourceVersion(), (Object)serverVersion.getMetadata().getResourceVersion());
        pipeline.getSpec().setCause(new PipelineCause("message", "type"));
        pipeline = (Pipeline)((NonNamespaceOperation)this.client.pipelines().inNamespace(this.namespace)).createOrReplace((Object[])new Pipeline[]{pipeline});
        PipelineTest.log("updated", pipeline);
        serverVersion = (Pipeline)((PipelineResource)((NonNamespaceOperation)this.client.pipelines().inNamespace(this.namespace)).withName(pipeline.getMetadata().getName())).get();
        Assert.assertNotNull((Object)pipeline);
        Assert.assertNotNull((Object)serverVersion);
        Assert.assertEquals((Object)pipeline.getSpec().getCause().getMessage(), (Object)serverVersion.getSpec().getCause().getMessage());
        Assert.assertEquals((Object)pipeline.getSpec().getCause().getType(), (Object)serverVersion.getSpec().getCause().getType());
        PipelineTest.log("deleted", ((PipelineResource)((NonNamespaceOperation)this.client.pipelines().inNamespace(this.namespace)).withName(pipeline.getMetadata().getName())).delete());
        PipelineTest.log("Done.");
    }

    @Test
    @Ignore(value="Needs real access to the API server")
    public void testEdit() {
        Assert.assertNotNull((Object)this.pipelineConfig);
        String name = "aaa";
        Assert.assertNotNull((Object)this.createBasicPipeline(name));
        PipelineList list = (PipelineList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pipelines().inNamespace(this.namespace)).withLabel("pipelineConfig", this.pipelineConfigName)).list();
        Assert.assertNotNull((Object)list);
        Assert.assertNotNull((Object)list.getItems());
        for (Pipeline pipe : list.getItems()) {
            name = pipe.getMetadata().getName();
            PipelineTest.log("name is " + name);
        }
        Assert.assertNotEquals((Object)"aaa", (Object)name);
        ((DoneablePipeline)((PipelineFluent.MetadataNested)((DoneablePipeline)((PipelineResource)((NonNamespaceOperation)this.client.pipelines().inNamespace(this.namespace)).withName(name)).edit()).editMetadata().addToAnnotations("AAA", "BBB")).endMetadata()).done();
        Pipeline pipe = (Pipeline)((PipelineResource)((NonNamespaceOperation)this.client.pipelines().inNamespace(this.namespace)).withName(name)).get();
        Assert.assertNotNull((Object)pipe.getMetadata());
        Assert.assertNotNull((Object)pipe.getMetadata().getAnnotations());
        Assert.assertTrue((boolean)pipe.getMetadata().getAnnotations().containsKey("AAA"));
        Assert.assertEquals((Object)"BBB", pipe.getMetadata().getAnnotations().get("AAA"));
        ((DoneablePipeline)((PipelineFluent.StatusNested)((PipelineStatusFluent.JenkinsNested)((PipelineStatusFluent.JenkinsNested)((PipelineStatusFluent.JenkinsNested)((PipelineStatusFluent.JenkinsNested)((PipelineStatusFluent.JenkinsNested)((PipelineFluent.StatusNested)((PipelineFluent.StatusNested)((PipelineFluent.StatusNested)((PipelineFluent.StatusNested)((DoneablePipeline)((PipelineResource)((NonNamespaceOperation)this.client.pipelines().inNamespace(this.namespace)).withName(name)).edit()).editStatus().withPhase("Running")).withFinishedAt("2018-10-01T00:00:00Z")).withStartedAt("2018-10-02T00:00:00Z")).withUpdatedAt("2018-10-03T00:00:00Z")).withNewJenkins().withBuild("1")).withResult("SUCCESS")).withStatus("FINISHED")).withStages("{\"sparta\": true}")).withStartStageID("1")).endJenkins()).endStatus()).done();
        pipe = (Pipeline)((PipelineResource)((NonNamespaceOperation)this.client.pipelines().inNamespace(this.namespace)).withName(name)).get();
        Assert.assertNotNull((Object)pipe.getStatus());
        Assert.assertEquals((Object)"Running", (Object)pipe.getStatus().getPhase());
        Assert.assertEquals((Object)"2018-10-01T00:00:00Z", (Object)pipe.getStatus().getFinishedAt());
        Assert.assertEquals((Object)"2018-10-02T00:00:00Z", (Object)pipe.getStatus().getStartedAt());
        Assert.assertEquals((Object)"2018-10-03T00:00:00Z", (Object)pipe.getStatus().getUpdatedAt());
        Assert.assertNotNull((Object)pipe.getStatus().getJenkins());
        Assert.assertEquals((Object)"1", (Object)pipe.getStatus().getJenkins().getBuild());
        Assert.assertEquals((Object)"SUCCESS", (Object)pipe.getStatus().getJenkins().getResult());
        Assert.assertEquals((Object)"FINISHED", (Object)pipe.getStatus().getJenkins().getStatus());
        Assert.assertEquals((Object)"{\"sparta\": true}", (Object)pipe.getStatus().getJenkins().getStages());
        Assert.assertEquals((Object)"1", (Object)pipe.getStatus().getJenkins().getStartStageID());
        ((DoneablePipeline)((PipelineFluent.StatusNested)((PipelineStatusFluent.JenkinsNested)((PipelineStatusFluent.JenkinsNested)((PipelineStatusFluent.JenkinsNested)((PipelineStatusFluent.JenkinsNested)((PipelineStatusFluent.JenkinsNested)((PipelineFluent.StatusNested)((PipelineFluent.StatusNested)((PipelineFluent.StatusNested)((PipelineFluent.StatusNested)((DoneablePipeline)((PipelineFluent.MetadataNested)((DoneablePipeline)((PipelineResource)((NonNamespaceOperation)this.client.pipelines().inNamespace(this.namespace)).withName(name)).edit()).editMetadata().addToAnnotations("AAA", "BBB")).endMetadata()).editStatus().withPhase("Running")).withFinishedAt("2018-10-01T00:00:00Z")).withStartedAt("2018-10-02T00:00:00Z")).withUpdatedAt("2018-10-03T00:00:00Z")).withNewJenkins().withBuild("1")).withResult("SUCCESS")).withStatus("FINISHED")).withStages("{\"sparta\": true}")).withStartStageID("1")).endJenkins()).endStatus()).done();
        pipe = (Pipeline)((PipelineResource)((NonNamespaceOperation)this.client.pipelines().inNamespace(this.namespace)).withName(name)).get();
        Assert.assertNotNull((Object)pipe.getMetadata());
        Assert.assertNotNull((Object)pipe.getMetadata().getAnnotations());
        Assert.assertTrue((boolean)pipe.getMetadata().getAnnotations().containsKey("AAA"));
        Assert.assertEquals((Object)"BBB", pipe.getMetadata().getAnnotations().get("AAA"));
        Assert.assertNotNull((Object)pipe.getStatus());
        Assert.assertEquals((Object)"Running", (Object)pipe.getStatus().getPhase());
        Assert.assertEquals((Object)"2018-10-01T00:00:00Z", (Object)pipe.getStatus().getFinishedAt());
        Assert.assertEquals((Object)"2018-10-02T00:00:00Z", (Object)pipe.getStatus().getStartedAt());
        Assert.assertEquals((Object)"2018-10-03T00:00:00Z", (Object)pipe.getStatus().getUpdatedAt());
        Assert.assertNotNull((Object)pipe.getStatus().getJenkins());
        Assert.assertEquals((Object)"1", (Object)pipe.getStatus().getJenkins().getBuild());
        Assert.assertEquals((Object)"SUCCESS", (Object)pipe.getStatus().getJenkins().getResult());
        Assert.assertEquals((Object)"FINISHED", (Object)pipe.getStatus().getJenkins().getStatus());
        Assert.assertEquals((Object)"{\"sparta\": true}", (Object)pipe.getStatus().getJenkins().getStages());
        Assert.assertEquals((Object)"1", (Object)pipe.getStatus().getJenkins().getStartStageID());
    }

    @Test
    @Ignore(value="Needs real access to the API server")
    public void testReplace() {
        Assert.assertNotNull((Object)this.pipelineConfig);
        String name = "aaa";
        Assert.assertNotNull((Object)this.createBasicPipeline(name));
        PipelineList list = (PipelineList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pipelines().inNamespace(this.namespace)).withLabel("pipelineConfig", this.pipelineConfigName)).list();
        Assert.assertNotNull((Object)list);
        Assert.assertNotNull((Object)list.getItems());
        for (Pipeline pipe : list.getItems()) {
            name = pipe.getMetadata().getName();
        }
        Assert.assertNotEquals((Object)"aaa", (Object)name);
        Pipeline pipeline = (Pipeline)((PipelineResource)((NonNamespaceOperation)this.client.pipelines().inNamespace(this.namespace)).withName(name)).get();
        pipeline.setStatus(((PipelineStatusBuilder)((PipelineStatusBuilder)((PipelineStatusBuilder)((PipelineStatusBuilder)((PipelineStatusBuilder)((PipelineStatusBuilder)new PipelineStatusBuilder().withAborted(Boolean.valueOf(false))).withFinishedAt("2018-10-01T00:00:00Z")).withStartedAt("2018-10-02T00:00:00Z")).withUpdatedAt("2018-10-03T00:00:00Z")).withPhase("Running")).withNewJenkins("1", "SUCCESS", "{\"sparta\": true}", "1", "FINISHED")).build());
        Pipeline returned = (Pipeline)((PipelineResource)((NonNamespaceOperation)this.client.pipelines().inNamespace(this.namespace)).withName(name)).replace((Object)pipeline);
        Assert.assertNotNull((Object)returned);
        PipelineTest.log("from update returned: " + returned);
        Pipeline pipe = (Pipeline)((PipelineResource)((NonNamespaceOperation)this.client.pipelines().inNamespace(this.namespace)).withName(name)).get();
        Assert.assertNotNull((Object)pipe.getStatus());
        Assert.assertEquals((Object)"Running", (Object)pipe.getStatus().getPhase());
        Assert.assertEquals((Object)"2018-10-01T00:00:00Z", (Object)pipe.getStatus().getFinishedAt());
        Assert.assertEquals((Object)"2018-10-02T00:00:00Z", (Object)pipe.getStatus().getStartedAt());
        Assert.assertEquals((Object)"2018-10-03T00:00:00Z", (Object)pipe.getStatus().getUpdatedAt());
        Assert.assertNotNull((Object)pipe.getStatus().getJenkins());
        Assert.assertEquals((Object)"1", (Object)pipe.getStatus().getJenkins().getBuild());
        Assert.assertEquals((Object)"SUCCESS", (Object)pipe.getStatus().getJenkins().getResult());
        Assert.assertEquals((Object)"FINISHED", (Object)pipe.getStatus().getJenkins().getStatus());
        Assert.assertEquals((Object)"{\"sparta\": true}", (Object)pipe.getStatus().getJenkins().getStages());
        Assert.assertEquals((Object)"1", (Object)pipe.getStatus().getJenkins().getStartStageID());
    }

    private static void log(String action, Object obj) {
        logger.error("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.error(action);
    }
}

