/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.client;

import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.devops.client.DefaultAlaudaDevOpsClient;
import io.alauda.kubernetes.client.Config;
import io.alauda.kubernetes.client.ConfigBuilder;
import io.alauda.kubernetes.client.utils.Serialization;
import java.net.MalformedURLException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AlaudaDevOpsConfigTest {
    private Config kubernetesConfig;
    private String version;

    @Before
    public void setup() {
        this.kubernetesConfig = ((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://2.2.2.2")).build();
        this.version = "v1";
        System.setProperty("kubernetes.api.version", this.version);
    }

    @After
    public void tearDown() {
        System.clearProperty("kubernetes.url");
        System.clearProperty("kubernetes.api.version");
    }

    @Test
    public void testOpenshiftURLAsRoot() {
        System.setProperty("kubernetes.url", "https://1.1.1.1");
        AlaudaDevOpsConfig config = new AlaudaDevOpsConfig(this.kubernetesConfig);
        Assert.assertEquals((Object)"https://1.1.1.1/", (Object)config.getKubernetesUrl());
    }

    @Test
    public void testOpenshiftURLAsRootWithSlash() {
        System.setProperty("kubernetes.url", "https://1.1.1.1/");
        AlaudaDevOpsConfig config = new AlaudaDevOpsConfig(this.kubernetesConfig);
        Assert.assertEquals((Object)"https://1.1.1.1/", (Object)config.getKubernetesUrl());
    }

    @Test
    public void testFullOpenshiftURL() {
        System.setProperty("kubernetes.url", "https://1.1.1.1/xxx");
        AlaudaDevOpsConfig config = new AlaudaDevOpsConfig(this.kubernetesConfig);
        Assert.assertEquals((Object)"https://1.1.1.1/xxx/", (Object)config.getKubernetesUrl());
    }

    @Test
    public void testNoOpenshiftURL() {
        System.clearProperty("kubernetes.url");
        AlaudaDevOpsConfig config = new AlaudaDevOpsConfig(this.kubernetesConfig);
        Assert.assertEquals((Object)"https://2.2.2.2/", (Object)config.getKubernetesUrl());
    }

    @Test
    public void shouldInstantiateClientUsingSerializeDeserialize() throws MalformedURLException {
        DefaultAlaudaDevOpsClient original = new DefaultAlaudaDevOpsClient();
        String json = Serialization.asJson((Object)original.getConfiguration());
        DefaultAlaudaDevOpsClient copy = DefaultAlaudaDevOpsClient.fromConfig((String)json);
        Assert.assertEquals((Object)original.getConfiguration().getMasterUrl(), (Object)copy.getConfiguration().getMasterUrl());
        Assert.assertEquals((Object)original.getConfiguration().getOauthToken(), (Object)copy.getConfiguration().getOauthToken());
        Assert.assertEquals((Object)original.getConfiguration().getNamespace(), (Object)copy.getConfiguration().getNamespace());
        Assert.assertEquals((Object)original.getConfiguration().getUsername(), (Object)copy.getConfiguration().getUsername());
        Assert.assertEquals((Object)original.getConfiguration().getPassword(), (Object)copy.getConfiguration().getPassword());
    }
}

