/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.client;

import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.devops.client.dsl.PipelineConfigResource;
import io.alauda.kubernetes.api.model.DoneablePipelineConfig;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.api.model.PipelineConfigFluent;
import io.alauda.kubernetes.api.model.PipelineConfigList;
import io.alauda.kubernetes.api.model.PipelineConfigSpecFluent;
import io.alauda.kubernetes.api.model.PipelineSourceFluent;
import io.alauda.kubernetes.api.model.PipelineStrategyFluent;
import io.alauda.kubernetes.api.model.PipelineTriggerFluent;
import io.alauda.kubernetes.client.Config;
import io.alauda.kubernetes.client.ConfigBuilder;
import io.alauda.kubernetes.client.DefaultKubernetesClient;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineConfigTest {
    private static final Logger logger = LoggerFactory.getLogger(PipelineConfigTest.class);

    public static PipelineConfig createPipelineConfig(AlaudaDevOpsClient client, String namespace, String name, String jenkinsBinding) {
        return ((DoneablePipelineConfig)((PipelineConfigFluent.SpecNested)((PipelineConfigSpecFluent.SourceNested)((PipelineSourceFluent.GitNested)((PipelineSourceFluent.GitNested)((PipelineConfigFluent.SpecNested)((PipelineConfigSpecFluent.StrategyNested)((PipelineStrategyFluent.JenkinsNested)((PipelineConfigFluent.SpecNested)((PipelineConfigSpecFluent.TriggersNested)((PipelineTriggerFluent.CronNested)((PipelineTriggerFluent.CronNested)((PipelineConfigSpecFluent.TriggersNested)((PipelineConfigFluent.SpecNested)((PipelineConfigFluent.SpecNested)((PipelineConfigFluent.SpecNested)((PipelineConfigSpecFluent.JenkinsBindingNested)((DoneablePipelineConfig)((PipelineConfigFluent.MetadataNested)((PipelineConfigFluent.MetadataNested)((DoneablePipelineConfig)((NonNamespaceOperation)client.pipelineConfigs().inNamespace(namespace)).createNew()).withNewMetadata().withName(name)).withNamespace(namespace)).endMetadata()).withNewSpec().withNewJenkinsBinding().withName(jenkinsBinding)).endJenkinsBinding()).withRunPolicy("Serial")).withNewRunLimits(new Long(10L), new Long(10L))).addNewTrigger().withType("cron")).withNewCron().withEnabled(Boolean.valueOf(true))).withRule("* * * * *")).endCron()).endTrigger()).withNewStrategy().withNewJenkins().withJenkinsfilePath("Jenkinsfile")).endJenkins()).endStrategy()).withNewSource().withNewGit().withUri("https://github.com/alauda/alauda")).withRef("master")).endGit()).endSource()).endSpec()).done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="Needs real access to the API server")
    public void testCreateGetUpdateDelete() {
        Config config = new ConfigBuilder().build();
        DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient(config);
        PipelineConfigTest.log("this is config", config);
        AlaudaDevOpsClient client = (AlaudaDevOpsClient)kubernetesClient.adapt(AlaudaDevOpsClient.class);
        PipelineConfigTest.log("this is client", client);
        String namespace = "default-1";
        String jenkinsBinding = "jenkins-dev-1";
        String name = "custom-pipeline-config";
        try {
            PipelineConfig pipelineConfig = PipelineConfigTest.createPipelineConfig(client, namespace, name, jenkinsBinding);
            Assert.assertNotNull((Object)pipelineConfig);
            PipelineConfigTest.log("Created pipeline config", pipelineConfig);
            PipelineConfigList list = (PipelineConfigList)((NonNamespaceOperation)client.pipelineConfigs().inNamespace(namespace)).list();
            Assert.assertNotNull((Object)list);
            Assert.assertNotNull((Object)list.getItems());
            Assert.assertTrue((list.getItems().size() > 0 ? 1 : 0) != 0);
            PipelineConfigTest.log("list", list);
            PipelineConfig serverVersion = (PipelineConfig)((PipelineConfigResource)((NonNamespaceOperation)client.pipelineConfigs().inNamespace(namespace)).withName(name)).get();
            PipelineConfigTest.log("retrieve from server", serverVersion);
            Assert.assertNotNull((Object)serverVersion);
            Assert.assertEquals((Object)pipelineConfig.getMetadata().getResourceVersion(), (Object)serverVersion.getMetadata().getResourceVersion());
            pipelineConfig.getSpec().getRunLimits().setFailureCount(Long.valueOf(15L));
            pipelineConfig = (PipelineConfig)((NonNamespaceOperation)client.pipelineConfigs().inNamespace(namespace)).createOrReplace((Object[])new PipelineConfig[]{pipelineConfig});
            PipelineConfigTest.log("updated", pipelineConfig);
            serverVersion = (PipelineConfig)((PipelineConfigResource)((NonNamespaceOperation)client.pipelineConfigs().inNamespace(namespace)).withName(name)).get();
            Assert.assertNotNull((Object)pipelineConfig);
            Assert.assertNotNull((Object)serverVersion);
            Assert.assertEquals((Object)pipelineConfig.getSpec().getRunLimits().getFailureCount(), (Object)serverVersion.getSpec().getRunLimits().getFailureCount());
            PipelineConfigTest.log("Done.");
        }
        finally {
            PipelineConfigTest.log("deleted", ((PipelineConfigResource)((NonNamespaceOperation)client.pipelineConfigs().inNamespace(namespace)).withName(name)).delete());
            client.close();
        }
    }

    private static void log(String action, Object obj) {
        logger.error("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.error(action);
    }
}

