/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.client;

import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.devops.client.JenkinsTest;
import io.alauda.kubernetes.api.model.DoneableJenkinsBinding;
import io.alauda.kubernetes.api.model.DoneableSecret;
import io.alauda.kubernetes.api.model.Jenkins;
import io.alauda.kubernetes.api.model.JenkinsBinding;
import io.alauda.kubernetes.api.model.JenkinsBindingFluent;
import io.alauda.kubernetes.api.model.JenkinsBindingList;
import io.alauda.kubernetes.api.model.JenkinsBindingSpecFluent;
import io.alauda.kubernetes.api.model.SecretFluent;
import io.alauda.kubernetes.api.model.UserAccountFluent;
import io.alauda.kubernetes.client.Config;
import io.alauda.kubernetes.client.ConfigBuilder;
import io.alauda.kubernetes.client.DefaultKubernetesClient;
import io.alauda.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import io.alauda.kubernetes.client.dsl.Resource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsBindingTest {
    private static final Logger logger = LoggerFactory.getLogger(JenkinsBindingTest.class);
    private AlaudaDevOpsClient client;
    private Jenkins jenkins;
    private String namespace = "default-1";
    private String jenkinsName = "jenkins-test";
    private String jenkinsHost = "http://baidu.com";
    private String secretName = "jenkins-secret-test";

    @Before
    public void before() {
        Config config = new ConfigBuilder().build();
        DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient(config);
        this.client = (AlaudaDevOpsClient)kubernetesClient.adapt(AlaudaDevOpsClient.class);
        this.jenkins = JenkinsTest.createJenkins(this.client, this.jenkinsName, this.jenkinsHost);
        ((DoneableSecret)((DoneableSecret)((DoneableSecret)((DoneableSecret)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)((DoneableSecret)((NonNamespaceOperation)kubernetesClient.secrets().inNamespace(this.namespace)).createNew()).withNewMetadata().withName(this.secretName)).withNamespace(this.namespace)).endMetadata()).withType("kubernetes.io/basic-auth")).addToStringData("username", "username")).addToStringData("password", "passowrd")).done();
    }

    @After
    public void after() {
        if (this.client != null) {
            ((Resource)this.client.jenkins().withName(this.jenkinsName)).delete();
            ((Resource)((NonNamespaceOperation)this.client.secrets().inNamespace(this.namespace)).withName(this.secretName)).delete();
            this.client.close();
        }
    }

    public JenkinsBinding createNew(String name) {
        return ((DoneableJenkinsBinding)((JenkinsBindingFluent.SpecNested)((JenkinsBindingSpecFluent.AccountNested)((UserAccountFluent.SecretNested)((UserAccountFluent.SecretNested)((UserAccountFluent.SecretNested)((JenkinsBindingFluent.SpecNested)((JenkinsBindingSpecFluent.JenkinsNested)((DoneableJenkinsBinding)((JenkinsBindingFluent.MetadataNested)((JenkinsBindingFluent.MetadataNested)((DoneableJenkinsBinding)((NonNamespaceOperation)this.client.jenkinsBindings().inNamespace(this.namespace)).createNew()).withNewMetadata().withName(name)).withNamespace(this.namespace)).endMetadata()).withNewSpec().withNewJenkins().withName(this.jenkinsName)).endJenkins()).withNewAccount().withNewSecret().withName(this.secretName)).withUsernameKey("username")).withApiTokenKey("password")).endSecret()).endAccount()).endSpec()).done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="Needs real access to the API server")
    public void testCreateGetUpdateDelete() {
        String name = "jenkins-binding-test";
        try {
            Assert.assertNotNull((Object)this.jenkins);
            JenkinsBinding jb = this.createNew(name);
            JenkinsBindingList list = (JenkinsBindingList)((NonNamespaceOperation)this.client.jenkinsBindings().inNamespace(this.namespace)).list();
            Assert.assertNotNull((Object)list);
            Assert.assertNotNull((Object)list.getItems());
            Assert.assertTrue((boolean)list.getItems().contains(jb));
            JenkinsBinding serverVer = (JenkinsBinding)((Resource)((NonNamespaceOperation)this.client.jenkinsBindings().inNamespace(this.namespace)).withName(name)).get();
            Assert.assertNotNull((Object)serverVer);
            Assert.assertEquals((Object)jb, (Object)serverVer);
            jb.getSpec().getAccount().getSecret().setApiTokenKey("another");
            jb = (JenkinsBinding)((NonNamespaceOperation)this.client.jenkinsBindings().inNamespace(this.namespace)).createOrReplace((Object[])new JenkinsBinding[]{jb});
            Assert.assertNotNull((Object)jb);
            serverVer = (JenkinsBinding)((Resource)((NonNamespaceOperation)this.client.jenkinsBindings().inNamespace(this.namespace)).withName(name)).get();
            Assert.assertEquals((Object)"another", (Object)serverVer.getSpec().getAccount().getSecret().getApiTokenKey());
            Assert.assertEquals((Object)serverVer.getSpec().getAccount().getSecret().getApiTokenKey(), (Object)jb.getSpec().getAccount().getSecret().getApiTokenKey());
            JenkinsBindingTest.log("Done.");
        }
        finally {
            JenkinsBindingTest.log("delete", ((Resource)((NonNamespaceOperation)this.client.jenkinsBindings().inNamespace(this.namespace)).withName(name)).delete());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="Needs real access to the API server")
    public void testListAllNamespaces() {
        String name = "jenkins-binding-test";
        try {
            Assert.assertNotNull((Object)this.jenkins);
            JenkinsBinding jb = this.createNew(name);
            JenkinsBindingList list = (JenkinsBindingList)((FilterWatchListMultiDeletable)this.client.jenkinsBindings().inAnyNamespace()).list();
            Assert.assertNotNull((Object)list);
            Assert.assertNotNull((Object)list.getItems());
            Assert.assertTrue((boolean)list.getItems().contains(jb));
            JenkinsBindingTest.log("Done.");
        }
        finally {
            JenkinsBindingTest.log("delete", ((Resource)((NonNamespaceOperation)this.client.jenkinsBindings().inNamespace(this.namespace)).withName(name)).delete());
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

