package io.alauda.devops.client.models;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.alauda.kubernetes.api.model.Doneable;
import io.alauda.kubernetes.api.model.KubernetesResource;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.annotation.Generated;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
  "apiVersion",
  "kind",
  "metadata",
  "jenkinsBinding",
  "runPolicy",
  "runLimits",
  "parameters",
  "triggers",
  "strategy",
  "hooks",
  "source",
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(builderPackage = "io.alauda.kubernetes.api.builder", editableEnabled = false, inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class PipelineConfigSpec implements KubernetesResource {

  @JsonProperty("jenkinsBinding")
  private LocalObjectReference jenkinsBinding;
  @JsonProperty("runPolicy")
  private String runPolicy;
  @JsonProperty("runLimits")
  private PipelineRunLimits runLimits;
  @JsonProperty("parameters")
  private List<PipelineParameter> parameters = new ArrayList<>();
  @JsonProperty("triggers")
  private List<PipelineTrigger> triggers = new ArrayList<>();
  @JsonProperty("strategy")
  private PipelineStrategy strategy;
  @JsonProperty("hooks")
  private List<PipelineHook> hooks = new ArrayList<>();
  @JsonProperty("source")
  private PipelineSource source;
  @JsonIgnore
  private Map<String, Object> additionalProperties = new HashMap<String, Object>();

  @JsonProperty("jenkinsBinding")
  public LocalObjectReference getJenkinsBinding() {
    return jenkinsBinding;
  }
  @JsonProperty("jenkinsBinding")
  public void setJenkinsBinding(LocalObjectReference jenkinsBinding) {
    this.jenkinsBinding = jenkinsBinding;
  }

  @JsonProperty("runPolicy")
  public String getRunPolicy() {
    return runPolicy;
  }
  @JsonProperty("runPolicy")
  public void setRunPolicy(String runPolicy) {
    this.runPolicy = runPolicy;
  }

  @JsonProperty("runLimits")
  public PipelineRunLimits getRunLimits() {
    return runLimits;
  }
  @JsonProperty("runLimits")
  public void setRunLimits(PipelineRunLimits runLimits) {
    this.runLimits = runLimits;
  }

  @JsonProperty("parameters")
  public List<PipelineParameter> getParameters() {
    return parameters;
  }
  @JsonProperty("parameters")
  public void setParameters(List<PipelineParameter> parameters) {
    this.parameters = parameters;
  }

  @JsonProperty("triggers")
  public List<PipelineTrigger> getTriggers() {
    return triggers;
  }
  @JsonProperty("triggers")
  public void setTriggers(List<PipelineTrigger> triggers) {
    this.triggers = triggers;
  }

  @JsonProperty("strategy")
  public PipelineStrategy getStrategy() {
    return strategy;
  }
  @JsonProperty("strategy")
  public void setStrategy(PipelineStrategy strategy) {
    this.strategy = strategy;
  }

  @JsonProperty("hooks")
  public List<PipelineHook> getHooks() {
    return hooks;
  }
  @JsonProperty("hooks")
  public void setHooks(List<PipelineHook> hooks) {
    this.hooks = hooks;
  }

  @JsonProperty("source")
  public PipelineSource getSource() {
    return source;
  }
  @JsonProperty("source")
  public void setSource(PipelineSource source) {
    this.source = source;
  }

  @JsonAnyGetter
  public Map<java.lang.String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  @JsonAnySetter
  public void setAdditionalProperty(java.lang.String name, Object value) {
    this.additionalProperties.put(name, value);
  }

  public PipelineConfigSpec(){
  }


  public PipelineConfigSpec(LocalObjectReference jenkinsBinding, String runPolicy, PipelineRunLimits runLimits, List<PipelineParameter> parameters, List<PipelineTrigger> triggers, PipelineStrategy strategy, List<PipelineHook> hooks, PipelineSource source) {
    this.jenkinsBinding = jenkinsBinding;
    this.runPolicy = runPolicy;
    this.runLimits = runLimits;
    this.parameters = parameters;
    this.triggers = triggers;
    this.strategy = strategy;
    this.hooks = hooks;
    this.source = source;
  }
}


