/**
 * Copyright (C) 2018 Alauda
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.alauda.devops.client.handlers;

import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.devops.client.dsl.internal.ProjectRequestsOperationImpl;
import io.alauda.kubernetes.client.Watch;
import io.alauda.kubernetes.client.Watcher;
import okhttp3.OkHttpClient;
import io.alauda.kubernetes.client.Config;
import io.alauda.kubernetes.client.ResourceHandler;
import io.alauda.devops.api.model.Project;
import io.alauda.devops.api.model.ProjectRequest;
import io.alauda.devops.api.model.ProjectRequestBuilder;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

import java.util.concurrent.TimeUnit;

@Component
@Service
public class ProjectRequestHandler implements ResourceHandler<ProjectRequest, ProjectRequestBuilder> {
  @Override
  public String getKind() {
    return Project.class.getSimpleName();
  }

  @Override
  public ProjectRequest create(OkHttpClient client, Config config, String namespace, ProjectRequest item) {
      return new ProjectRequestsOperationImpl(client, AlaudaDevOpsConfig.wrap(config), null, item).create();
  }

  @Override
  public ProjectRequest replace(OkHttpClient client, Config config, String namespace, ProjectRequest item) {
    throw new UnsupportedOperationException();
  }

  @Override
  public ProjectRequest reload(OkHttpClient client, Config config, String namespace, ProjectRequest item) {
    throw new UnsupportedOperationException();
  }

  @Override
  public ProjectRequestBuilder edit(ProjectRequest item) {
    return new ProjectRequestBuilder(item);
  }


  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, ProjectRequest item) {
    throw new UnsupportedOperationException();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ProjectRequest item, Watcher<ProjectRequest> watcher) {
    throw new UnsupportedOperationException();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ProjectRequest item, String resourceVersion, Watcher<ProjectRequest> watcher) {
    throw new UnsupportedOperationException();
  }

  @Override
  public ProjectRequest waitUntilReady(OkHttpClient client, Config config, String namespace, ProjectRequest item, long amount, TimeUnit timeUnit) throws InterruptedException {
    throw new UnsupportedOperationException();
  }
}
