/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.client.dsl.internal;

import io.alauda.devops.api.model.DoneableRoleBinding;
import io.alauda.devops.api.model.RoleBinding;
import io.alauda.devops.api.model.RoleBindingBuilder;
import io.alauda.devops.api.model.RoleBindingFluent;
import io.alauda.devops.api.model.RoleBindingList;
import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.devops.client.dsl.internal.AlaudaOperation;
import io.alauda.kubernetes.api.builder.TypedVisitor;
import io.alauda.kubernetes.api.builder.Visitor;
import io.alauda.kubernetes.api.model.HasMetadata;
import io.alauda.kubernetes.api.model.ObjectReference;
import io.alauda.kubernetes.api.model.ObjectReferenceBuilder;
import io.alauda.kubernetes.client.KubernetesClientException;
import io.alauda.kubernetes.client.dsl.Resource;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import okhttp3.OkHttpClient;

public class RoleBindingOperationsImpl
extends AlaudaOperation<RoleBinding, RoleBindingList, DoneableRoleBinding, Resource<RoleBinding, DoneableRoleBinding>> {
    public RoleBindingOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String namespace) {
        this(client, config, null, namespace, null, (Boolean)true, null, null, (Boolean)false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public RoleBindingOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion, String namespace, String name, Boolean cascading, RoleBinding item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, AlaudaOperation.withApiGroup(client, "authorization.devops.io", apiVersion, config), "rolebindings", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
    }

    public RoleBinding replace(RoleBinding item) {
        RoleBinding enriched = this.enrichRoleBinding(item);
        return (RoleBinding)super.replace((HasMetadata)enriched);
    }

    public RoleBinding patch(RoleBinding item) {
        RoleBinding enriched = this.enrichRoleBinding(item);
        return (RoleBinding)super.patch((HasMetadata)enriched);
    }

    protected RoleBinding handleCreate(RoleBinding resource) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        return (RoleBinding)super.handleCreate((Object)this.enrichRoleBinding(resource));
    }

    private RoleBinding enrichRoleBinding(RoleBinding binding) {
        RoleBindingBuilder builder = new RoleBindingBuilder(binding);
        if (binding.getUserNames() != null && !binding.getUserNames().isEmpty() || binding.getGroupNames() != null && !binding.getGroupNames().isEmpty()) {
            this.enrichFromUsersAndGroups(builder, binding.getUserNames(), binding.getGroupNames());
        } else {
            this.enrichFromSubjects(builder, binding.getSubjects());
            this.enrichSubjectsNamespace(builder);
        }
        return builder.build();
    }

    private void enrichSubjectsNamespace(RoleBindingBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ObjectReferenceBuilder>(){

            public void visit(ObjectReferenceBuilder o) {
                if (o.getKind() != null && o.getKind().equals("ServiceAccount") && (o.getNamespace() == null || o.getNamespace().isEmpty())) {
                    o.withNamespace(RoleBindingOperationsImpl.this.getNamespace());
                }
            }
        });
    }

    private void enrichFromUsersAndGroups(RoleBindingBuilder builder, List<String> userNames, List<String> groupNames) {
        builder.withSubjects(new ObjectReference[0]);
        if (userNames != null) {
            for (String userName : userNames) {
                String[] splitUserName;
                if (userName.startsWith("system:serviceaccount:") && (splitUserName = userName.split(":")).length == 4) {
                    ((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind("ServiceAccount")).withNamespace(splitUserName[2])).withName(splitUserName[3])).endSubject();
                    continue;
                }
                ((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind("User")).withName(userName)).endSubject();
            }
        }
        if (groupNames != null) {
            for (String groupName : groupNames) {
                ((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind("Group")).withName(groupName)).endSubject();
            }
        }
    }

    private void enrichFromSubjects(RoleBindingBuilder builder, List<ObjectReference> subjects) {
        for (ObjectReference ref : subjects) {
            switch (ref.getKind()) {
                case "User": {
                    builder.addToUserNames(new String[]{ref.getName()});
                    break;
                }
                case "ServiceAccount": {
                    String namespace = ref.getNamespace();
                    if (namespace == null || namespace.isEmpty()) {
                        namespace = this.getNamespace();
                    }
                    builder.addToUserNames(new String[]{"system:serviceaccount:" + namespace + ":" + ref.getName()});
                    break;
                }
                case "Group": {
                    builder.addToGroupNames(new String[]{ref.getName()});
                }
            }
        }
    }
}

