/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.client.dsl.internal;

import io.alauda.devops.api.model.DoneableProjectRequest;
import io.alauda.devops.api.model.ProjectRequest;
import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.devops.client.dsl.ProjectRequestOperation;
import io.alauda.devops.client.dsl.internal.AlaudaOperation;
import io.alauda.kubernetes.api.builder.Function;
import io.alauda.kubernetes.api.model.Status;
import io.alauda.kubernetes.client.KubernetesClientException;
import io.alauda.kubernetes.client.dsl.base.OperationSupport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class ProjectRequestsOperationImpl
extends OperationSupport
implements ProjectRequestOperation {
    private final ProjectRequest item;

    public ProjectRequestsOperationImpl(OkHttpClient client, AlaudaDevOpsConfig config) {
        this(client, config, null, null);
    }

    public ProjectRequestsOperationImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion, ProjectRequest item) {
        super(client, AlaudaOperation.withApiGroup(client, "project.devops.io", apiVersion, config), "projectrequests", null, null);
        this.item = item;
    }

    public boolean isResourceNamespaced() {
        return false;
    }

    public URL getRootUrl() {
        try {
            return new URL(AlaudaDevOpsConfig.wrap(this.getConfig()).getKubernetesUrl());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    private ProjectRequest updateApiVersion(ProjectRequest p) {
        p.setApiVersion(this.apiVersion);
        return p;
    }

    public ProjectRequest create(ProjectRequest ... resources) {
        try {
            if (resources.length > 1) {
                throw new IllegalArgumentException("Too many items to create.");
            }
            if (resources.length == 1) {
                return (ProjectRequest)this.handleCreate(this.updateApiVersion(resources[0]), ProjectRequest.class);
            }
            if (this.getItem() == null) {
                throw new IllegalArgumentException("Nothing to create.");
            }
            return (ProjectRequest)this.handleCreate(this.updateApiVersion(this.getItem()), ProjectRequest.class);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public DoneableProjectRequest createNew() {
        return new DoneableProjectRequest((Function)new Function<ProjectRequest, ProjectRequest>(){

            public ProjectRequest apply(ProjectRequest item) {
                try {
                    return ProjectRequestsOperationImpl.this.create(item);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable((Throwable)e);
                }
            }
        });
    }

    public Status list() {
        try {
            URL requestUrl = this.getNamespacedUrl();
            Request.Builder requestBuilder = new Request.Builder().get().url(requestUrl);
            return (Status)this.handleResponse(requestBuilder, Status.class);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public ProjectRequest getItem() {
        return this.item;
    }
}

