package io.alauda.devops.client.models;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.alauda.kubernetes.api.model.Doneable;
import io.alauda.kubernetes.api.model.KubernetesResource;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonPropertyOrder({
  "apiVersion",
  "kind",
  "metadata",
  "phase",
  "reason",
  "message",
  "lastAttempt",
  "conditions"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(builderPackage = "io.alauda.kubernetes.api.builder", editableEnabled = false, inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class PipelineConfigStatus implements KubernetesResource {
  public static final String PipelineConfigPhaseCreating = "Creating";
  public static final String PipelineConfigPhaseSyncing = "Syncing";
  public static final String PipelineConfigPhaseReady = "Ready";
  public static final String PipelineConfigPhaseError = "Error";

  @JsonProperty("phase")
  private String phase;
  @JsonProperty("reason")
  private String reason;
  @JsonProperty("message")
  private String message;
  @JsonProperty("lastAttempt")
  private String lastAttempt;
  @JsonProperty("conditions")
  private List<Condition> conditions = new ArrayList<>();

  @JsonProperty("phase")
  public String getPhase() {
    return phase;
  }
  @JsonProperty("phase")
  public void setPhase(String phase) {
    this.phase = phase;
  }
  @JsonProperty("reason")
  public String getReason() {
    return reason;
  }
  @JsonProperty("reason")
  public void setReason(String reason) {
    this.reason = reason;
  }
  @JsonProperty("message")
  public String getMessage() {
    return message;
  }
  @JsonProperty("message")
  public void setMessage(String message) {
    this.message = message;
  }
  @JsonProperty("lastAttempt")
  public String getLastAttempt() {
    return lastAttempt;
  }
  @JsonProperty("lastAttempt")
  public void setLastAttempt(String lastAttempt) {
    this.lastAttempt = lastAttempt;
  }

  @JsonProperty("conditions")
  public List<Condition> getConditions() {
    return conditions;
  }
  @JsonProperty("conditions")
  public void setConditions(List<Condition> conditions) {
    this.conditions = conditions;
  }
  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }
  @JsonAnySetter
  public void setAdditionalProperties(Map<String, Object> additionalProperties) {
    this.additionalProperties = additionalProperties;
  }

  @JsonIgnore
  private Map<String, Object> additionalProperties = new HashMap<String, Object>();

  public PipelineConfigStatus(){
  }

  public PipelineConfigStatus(String phase, String reason, String message, String lastAttempt, List<Condition> conditions) {
    this.phase = phase;
    this.reason = reason;
    this.message = message;
    this.lastAttempt = lastAttempt;
    this.conditions = conditions;
  }
}
