package io.alauda.devops.client.handlers;

import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.kubernetes.client.Config;
import io.alauda.kubernetes.client.ResourceHandler;
import io.alauda.kubernetes.client.Watch;
import io.alauda.kubernetes.client.Watcher;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.api.model.PipelineConfigBuilder;
import io.alauda.devops.client.dsl.internal.PipelineConfigOperationsImpl;

import okhttp3.OkHttpClient;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;


@Component
@Service
public class PipelineConfigHandler implements ResourceHandler<PipelineConfig, PipelineConfigBuilder> {

  @Override
  public String getKind() {
    return PipelineConfig.class.getSimpleName();
  }

  @Override
  public PipelineConfig create(OkHttpClient client, Config config, String namespace, PipelineConfig item) {
    AlaudaDevOpsConfig osConfig = AlaudaDevOpsConfig.wrap(config);
    return new PipelineConfigOperationsImpl(client, AlaudaDevOpsConfig.wrap(config), null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, null, null, null, osConfig.getBuildTimeout(), TimeUnit.MILLISECONDS).create();
  }

  @Override
  public PipelineConfig replace(OkHttpClient client, Config config, String namespace, PipelineConfig item) {
    AlaudaDevOpsConfig osConfig = AlaudaDevOpsConfig.wrap(config);
    return new PipelineConfigOperationsImpl(client, AlaudaDevOpsConfig.wrap(config), null, namespace, null, true, item, null, true, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, null, null, null, osConfig.getBuildTimeout(), TimeUnit.MILLISECONDS).replace(item);
  }

  @Override
  public PipelineConfig reload(OkHttpClient client, Config config, String namespace, PipelineConfig item) {
    AlaudaDevOpsConfig osConfig = AlaudaDevOpsConfig.wrap(config);
    return new PipelineConfigOperationsImpl(client, osConfig, null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, null, null, null, osConfig.getBuildTimeout(), TimeUnit.MILLISECONDS).fromServer().get();
  }

  @Override
  public PipelineConfigBuilder edit(PipelineConfig item) {
    return new PipelineConfigBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, PipelineConfig item) {
    AlaudaDevOpsConfig osConfig = AlaudaDevOpsConfig.wrap(config);
    return new PipelineConfigOperationsImpl(client, AlaudaDevOpsConfig.wrap(config), null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, null, null, null, osConfig.getBuildTimeout(), TimeUnit.MILLISECONDS).delete(item);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PipelineConfig item, Watcher<PipelineConfig> watcher) {
    AlaudaDevOpsConfig osConfig = AlaudaDevOpsConfig.wrap(config);
    return new PipelineConfigOperationsImpl(client, osConfig, null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, null, null, null, osConfig.getBuildTimeout(), TimeUnit.MILLISECONDS).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PipelineConfig item, String resourceVersion, Watcher<PipelineConfig> watcher) {
    AlaudaDevOpsConfig osConfig = AlaudaDevOpsConfig.wrap(config);
    return new PipelineConfigOperationsImpl(client, osConfig, null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, null, null, null, osConfig.getBuildTimeout(), TimeUnit.MILLISECONDS).watch(resourceVersion, watcher);
  }

  @Override
  public PipelineConfig waitUntilReady(OkHttpClient client, Config config, String namespace, PipelineConfig item, long amount, TimeUnit timeUnit) throws InterruptedException {
    AlaudaDevOpsConfig osConfig = AlaudaDevOpsConfig.wrap(config);
    return new PipelineConfigOperationsImpl(client, osConfig, null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, null, null, null, osConfig.getBuildTimeout(), TimeUnit.MILLISECONDS).waitUntilReady(amount, timeUnit);
  }
}
