/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.client.models;

import io.alauda.devops.client.models.LocalObjectReference;
import io.alauda.devops.client.models.LocalObjectReferenceBuilder;
import io.alauda.devops.client.models.LocalObjectReferenceFluentImpl;
import io.alauda.devops.client.models.PipelineConfigSpec;
import io.alauda.devops.client.models.PipelineConfigSpecFluent;
import io.alauda.devops.client.models.PipelineHook;
import io.alauda.devops.client.models.PipelineParameter;
import io.alauda.devops.client.models.PipelineParameterBuilder;
import io.alauda.devops.client.models.PipelineParameterFluentImpl;
import io.alauda.devops.client.models.PipelineRunLimits;
import io.alauda.devops.client.models.PipelineRunLimitsBuilder;
import io.alauda.devops.client.models.PipelineRunLimitsFluentImpl;
import io.alauda.devops.client.models.PipelineSource;
import io.alauda.devops.client.models.PipelineStrategy;
import io.alauda.devops.client.models.PipelineTrigger;
import io.alauda.kubernetes.api.builder.BaseFluent;
import io.alauda.kubernetes.api.builder.Nested;
import io.alauda.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.List;

public class PipelineConfigSpecFluentImpl<A extends PipelineConfigSpecFluent<A>>
extends BaseFluent<A>
implements PipelineConfigSpecFluent<A> {
    private VisitableBuilder<? extends LocalObjectReference, ?> jenkinsBinding;
    private String runPolicy;
    private VisitableBuilder<? extends PipelineRunLimits, ?> runLimits;
    private List<VisitableBuilder<? extends PipelineParameter, ?>> parameters = new ArrayList();
    private List<PipelineTrigger> triggers = new ArrayList<PipelineTrigger>();
    private PipelineStrategy strategy;
    private List<PipelineHook> hooks = new ArrayList<PipelineHook>();
    private PipelineSource source;

    public PipelineConfigSpecFluentImpl() {
    }

    public PipelineConfigSpecFluentImpl(PipelineConfigSpec instance) {
        this.withJenkinsBinding(instance.getJenkinsBinding());
        this.withRunPolicy(instance.getRunPolicy());
        this.withRunLimits(instance.getRunLimits());
        this.withParameters(instance.getParameters());
        this.withTriggers(instance.getTriggers());
        this.withStrategy(instance.getStrategy());
        this.withHooks(instance.getHooks());
        this.withSource(instance.getSource());
    }

    @Override
    public LocalObjectReference getJenkinsBinding() {
        return this.jenkinsBinding != null ? (LocalObjectReference)this.jenkinsBinding.build() : null;
    }

    @Override
    public A withJenkinsBinding(LocalObjectReference jenkinsBinding) {
        this._visitables.remove(this.jenkinsBinding);
        if (jenkinsBinding != null) {
            this.jenkinsBinding = new LocalObjectReferenceBuilder(jenkinsBinding);
            this._visitables.add(this.jenkinsBinding);
        }
        return (A)this;
    }

    @Override
    public PipelineConfigSpecFluent.JenkinsBindingNested<A> withNewJenkinsBinding() {
        return new JenkinsBindingNestedImpl();
    }

    @Override
    public PipelineConfigSpecFluent.JenkinsBindingNested<A> withNewJenkinsBindingLike(LocalObjectReference item) {
        return new JenkinsBindingNestedImpl(item);
    }

    @Override
    public PipelineConfigSpecFluent.JenkinsBindingNested<A> editJenkinsBinding() {
        return this.withNewJenkinsBindingLike(this.getJenkinsBinding());
    }

    @Override
    public PipelineConfigSpecFluent.JenkinsBindingNested<A> editOrNewJenkinsBinding() {
        return this.withNewJenkinsBindingLike(this.getJenkinsBinding() != null ? this.getJenkinsBinding() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public PipelineConfigSpecFluent.JenkinsBindingNested<A> editOrNewJenkinsBindingLike(LocalObjectReference item) {
        return this.withNewJenkinsBindingLike(this.getJenkinsBinding() != null ? this.getJenkinsBinding() : item);
    }

    @Override
    public String getRunPolicy() {
        return this.runPolicy;
    }

    @Override
    public A withRunPolicy(String runPolicy) {
        this.runPolicy = runPolicy;
        return (A)this;
    }

    @Override
    public PipelineRunLimits getRunLimits() {
        return this.runLimits != null ? (PipelineRunLimits)this.runLimits.build() : null;
    }

    @Override
    public A withRunLimits(PipelineRunLimits runLimits) {
        this._visitables.remove(this.runLimits);
        if (runLimits != null) {
            this.runLimits = new PipelineRunLimitsBuilder(runLimits);
            this._visitables.add(this.runLimits);
        }
        return (A)this;
    }

    @Override
    public PipelineConfigSpecFluent.RunLimitsNested<A> withNewRunLimits() {
        return new RunLimitsNestedImpl();
    }

    @Override
    public PipelineConfigSpecFluent.RunLimitsNested<A> withNewRunLimitsLike(PipelineRunLimits item) {
        return new RunLimitsNestedImpl(item);
    }

    @Override
    public PipelineConfigSpecFluent.RunLimitsNested<A> editRunLimits() {
        return this.withNewRunLimitsLike(this.getRunLimits());
    }

    @Override
    public PipelineConfigSpecFluent.RunLimitsNested<A> editOrNewRunLimits() {
        return this.withNewRunLimitsLike(this.getRunLimits() != null ? this.getRunLimits() : new PipelineRunLimitsBuilder().build());
    }

    @Override
    public PipelineConfigSpecFluent.RunLimitsNested<A> editOrNewRunLimitsLike(PipelineRunLimits item) {
        return this.withNewRunLimitsLike(this.getRunLimits() != null ? this.getRunLimits() : item);
    }

    @Override
    public A withNewRunLimits(Long successCount, Long failureCount) {
        return this.withRunLimits(new PipelineRunLimits(successCount, failureCount));
    }

    @Override
    public A addToParameters(PipelineParameter ... items) {
        for (PipelineParameter item : items) {
            PipelineParameterBuilder builder = new PipelineParameterBuilder(item);
            this._visitables.add(builder);
            this.parameters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromParameters(PipelineParameter ... items) {
        for (PipelineParameter item : items) {
            PipelineParameterBuilder builder = new PipelineParameterBuilder(item);
            this._visitables.remove(builder);
            this.parameters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<PipelineParameter> getParameters() {
        return PipelineConfigSpecFluentImpl.build(this.parameters);
    }

    @Override
    public A withParameters(List<PipelineParameter> parameters) {
        this._visitables.removeAll(this.parameters);
        this.parameters.clear();
        if (parameters != null) {
            for (PipelineParameter item : parameters) {
                this.addToParameters(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withParameters(PipelineParameter ... parameters) {
        this.parameters.clear();
        if (parameters != null) {
            for (PipelineParameter item : parameters) {
                this.addToParameters(item);
            }
        }
        return (A)this;
    }

    @Override
    public PipelineConfigSpecFluent.ParametersNested<A> addNewParameter() {
        return new ParametersNestedImpl();
    }

    @Override
    public PipelineConfigSpecFluent.ParametersNested<A> addNewParameterLike(PipelineParameter item) {
        return new ParametersNestedImpl(item);
    }

    @Override
    public A addToTriggers(PipelineTrigger ... items) {
        for (PipelineTrigger item : items) {
            this.triggers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTriggers(PipelineTrigger ... items) {
        for (PipelineTrigger item : items) {
            this.triggers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<PipelineTrigger> getTriggers() {
        return this.triggers;
    }

    @Override
    public A withTriggers(List<PipelineTrigger> triggers) {
        this.triggers.clear();
        if (triggers != null) {
            for (PipelineTrigger item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTriggers(PipelineTrigger ... triggers) {
        this.triggers.clear();
        if (triggers != null) {
            for (PipelineTrigger item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (A)this;
    }

    @Override
    public PipelineStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public A withStrategy(PipelineStrategy strategy) {
        this.strategy = strategy;
        return (A)this;
    }

    @Override
    public A addToHooks(PipelineHook ... items) {
        for (PipelineHook item : items) {
            this.hooks.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHooks(PipelineHook ... items) {
        for (PipelineHook item : items) {
            this.hooks.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<PipelineHook> getHooks() {
        return this.hooks;
    }

    @Override
    public A withHooks(List<PipelineHook> hooks) {
        this.hooks.clear();
        if (hooks != null) {
            for (PipelineHook item : hooks) {
                this.addToHooks(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withHooks(PipelineHook ... hooks) {
        this.hooks.clear();
        if (hooks != null) {
            for (PipelineHook item : hooks) {
                this.addToHooks(item);
            }
        }
        return (A)this;
    }

    @Override
    public PipelineSource getSource() {
        return this.source;
    }

    @Override
    public A withSource(PipelineSource source) {
        this.source = source;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PipelineConfigSpecFluentImpl that = (PipelineConfigSpecFluentImpl)o;
        if (this.jenkinsBinding != null ? !this.jenkinsBinding.equals(that.jenkinsBinding) : that.jenkinsBinding != null) {
            return false;
        }
        if (this.runPolicy != null ? !this.runPolicy.equals(that.runPolicy) : that.runPolicy != null) {
            return false;
        }
        if (this.runLimits != null ? !this.runLimits.equals(that.runLimits) : that.runLimits != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        if (this.triggers != null ? !this.triggers.equals(that.triggers) : that.triggers != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        if (this.hooks != null ? !this.hooks.equals(that.hooks) : that.hooks != null) {
            return false;
        }
        return !(this.source != null ? !this.source.equals(that.source) : that.source != null);
    }

    public class ParametersNestedImpl<N>
    extends PipelineParameterFluentImpl<PipelineConfigSpecFluent.ParametersNested<N>>
    implements PipelineConfigSpecFluent.ParametersNested<N>,
    Nested<N> {
        private final PipelineParameterBuilder builder;

        ParametersNestedImpl(PipelineParameter item) {
            this.builder = new PipelineParameterBuilder(this, item);
        }

        ParametersNestedImpl() {
            this.builder = new PipelineParameterBuilder(this);
        }

        @Override
        public N and() {
            return (N)PipelineConfigSpecFluentImpl.this.addToParameters(this.builder.build());
        }

        @Override
        public N endParameter() {
            return this.and();
        }
    }

    public class RunLimitsNestedImpl<N>
    extends PipelineRunLimitsFluentImpl<PipelineConfigSpecFluent.RunLimitsNested<N>>
    implements PipelineConfigSpecFluent.RunLimitsNested<N>,
    Nested<N> {
        private final PipelineRunLimitsBuilder builder;

        RunLimitsNestedImpl(PipelineRunLimits item) {
            this.builder = new PipelineRunLimitsBuilder(this, item);
        }

        RunLimitsNestedImpl() {
            this.builder = new PipelineRunLimitsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PipelineConfigSpecFluentImpl.this.withRunLimits(this.builder.build());
        }

        @Override
        public N endRunLimits() {
            return this.and();
        }
    }

    public class JenkinsBindingNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<PipelineConfigSpecFluent.JenkinsBindingNested<N>>
    implements PipelineConfigSpecFluent.JenkinsBindingNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        JenkinsBindingNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        JenkinsBindingNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PipelineConfigSpecFluentImpl.this.withJenkinsBinding(this.builder.build());
        }

        @Override
        public N endJenkinsBinding() {
            return this.and();
        }
    }
}

