/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.client.dsl.internal;

import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.devops.client.dsl.BuildConfigOperation;
import io.alauda.devops.client.dsl.BuildConfigResource;
import io.alauda.devops.client.dsl.BuildResource;
import io.alauda.devops.client.dsl.InputStreamable;
import io.alauda.devops.client.dsl.TimeoutInputStreamable;
import io.alauda.devops.client.dsl.buildconfig.AsFileTimeoutInputStreamable;
import io.alauda.devops.client.dsl.buildconfig.AuthorEmailable;
import io.alauda.devops.client.dsl.buildconfig.AuthorMessageAsFileTimeoutInputStreamable;
import io.alauda.devops.client.dsl.buildconfig.CommitterAuthorMessageAsFileTimeoutInputStreamable;
import io.alauda.devops.client.dsl.buildconfig.CommitterEmailable;
import io.alauda.devops.client.dsl.buildconfig.MessageAsFileTimeoutInputStreamable;
import io.alauda.devops.client.dsl.internal.AlaudaOperation;
import io.alauda.devops.client.dsl.internal.BuildOperationsImpl;
import io.alauda.kubernetes.api.model.HasMetadata;
import io.alauda.kubernetes.client.KubernetesClientException;
import io.alauda.kubernetes.client.Watch;
import io.alauda.kubernetes.client.Watcher;
import io.alauda.kubernetes.client.dsl.Gettable;
import io.alauda.kubernetes.client.dsl.Reaper;
import io.alauda.kubernetes.client.dsl.Triggerable;
import io.alauda.kubernetes.client.dsl.Typeable;
import io.alauda.kubernetes.client.dsl.Watchable;
import io.alauda.kubernetes.client.utils.URLUtils;
import io.alauda.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.WebHookTrigger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class BuildConfigOperationsImpl
extends AlaudaOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, BuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build>>
implements BuildConfigOperation {
    public static final String BUILD_CONFIG_LABEL = "devops.io/build-config.name";
    public static final String BUILD_CONFIG_ANNOTATION = "devops.io/build-config.name";
    private final String secret;
    private final String triggerType;
    private final String authorName;
    private final String authorEmail;
    private final String committerName;
    private final String committerEmail;
    private final String commit;
    private final String message;
    private final String asFile;
    private final long timeout;
    private final TimeUnit timeoutUnit;

    public BuildConfigOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String namespace) {
        this(client, config, null, namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, null, null, null, config.getBuildTimeout(), TimeUnit.MILLISECONDS);
    }

    public BuildConfigOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion, String namespace, String name, Boolean cascading, BuildConfig item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        this(client, config, apiVersion, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields, null, null, null, null, null, null, null, null, null, config.getBuildTimeout(), TimeUnit.MILLISECONDS);
    }

    public BuildConfigOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion, String namespace, String name, Boolean cascading, BuildConfig item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, String secret, String triggerType, String authorName, String authorEmail, String committerName, String committerEmail, String commit, String message, String asFile, long timeout, TimeUnit timeoutUnit) {
        super(client, AlaudaOperation.withApiGroup(client, "build.devops.io", apiVersion, config), "buildconfigs", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.triggerType = triggerType;
        this.secret = secret;
        this.authorName = authorName;
        this.authorEmail = authorEmail;
        this.committerName = committerName;
        this.committerEmail = committerEmail;
        this.commit = commit;
        this.message = message;
        this.asFile = asFile;
        this.reaper = new BuildConfigReaper(this);
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
    }

    public BuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build> withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), name, this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, this.message, this.asFile, this.timeout, this.timeoutUnit);
    }

    @Override
    public AlaudaOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, BuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build>> inNamespace(String namespace) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), namespace, this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, this.message, this.asFile, this.timeout, this.timeoutUnit);
    }

    public Gettable<BuildConfig> fromServer() {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), true, this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, this.message, this.asFile, this.timeout, this.timeoutUnit);
    }

    public Typeable<Triggerable<WebHookTrigger, Void>> withSecret(String secret) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), secret, this.triggerType, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, this.message, this.asFile, this.timeout, this.timeoutUnit);
    }

    public BuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build> load(InputStream is) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)BuildConfigOperationsImpl.unmarshal((InputStream)is, (Class)this.getType()), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, this.message, this.asFile, this.timeout, this.timeoutUnit);
    }

    @Override
    public Build instantiate(BuildRequest request) {
        try {
            this.updateApiVersion((HasMetadata)request);
            URL instantiationUrl = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "instantiate"}));
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)JSON_MAPPER.writer().writeValueAsString((Object)request));
            Request.Builder requestBuilder = new Request.Builder().post(requestBody).url(instantiationUrl);
            return (Build)this.handleResponse(requestBuilder, Build.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    @Override
    public CommitterAuthorMessageAsFileTimeoutInputStreamable<Build> instantiateBinary() {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, this.message, this.asFile, this.timeout, this.timeoutUnit);
    }

    public Void trigger(WebHookTrigger trigger) {
        try {
            String triggerUrl = URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "webhooks", this.secret, this.triggerType});
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (byte[])JSON_MAPPER.writer().writeValueAsBytes((Object)trigger));
            Request.Builder requestBuilder = new Request.Builder().post(requestBody).url(triggerUrl).addHeader("X-Github-Event", "push");
            this.handleResponse(requestBuilder, null);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        return null;
    }

    public Triggerable<WebHookTrigger, Void> withType(String type) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, type, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, this.message, this.asFile, this.timeout, this.timeoutUnit);
    }

    public Watchable<Watch, Watcher<BuildConfig>> withResourceVersion(String resourceVersion) {
        BuildConfigOperationsImpl buildConfigOperations = new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (BuildConfig)this.getItem(), resourceVersion, this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, this.message, this.asFile, this.timeout, this.timeoutUnit);
        return buildConfigOperations;
    }

    private void deleteBuilds() {
        if (this.getName() == null) {
            return;
        }
        String buildConfigLabelValue = this.getName().substring(0, Math.min(this.getName().length(), 63));
        BuildList matchingBuilds = (BuildList)new BuildOperationsImpl(this.client, (AlaudaDevOpsConfig)this.config, this.namespace).inNamespace(this.namespace).withLabel("devops.io/build-config.name", buildConfigLabelValue).list();
        if (matchingBuilds.getItems() != null) {
            for (Build matchingBuild : matchingBuilds.getItems()) {
                if (matchingBuild.getMetadata() == null || matchingBuild.getMetadata().getAnnotations() == null || !this.getName().equals(matchingBuild.getMetadata().getAnnotations().get("devops.io/build-config.name"))) continue;
                ((BuildResource)new BuildOperationsImpl(this.client, (AlaudaDevOpsConfig)this.config, this.namespace).inNamespace(matchingBuild.getMetadata().getNamespace()).withName(matchingBuild.getMetadata().getName())).delete();
            }
        }
    }

    @Override
    public Build fromInputStream(InputStream inputStream) {
        return this.fromInputStream(inputStream, -1L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Build fromFile(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("Can't instantiate binary build from the specified file. The file does not exists");
        }
        try (FileInputStream is = new FileInputStream(file);){
            Build build = this.fromInputStream(is, file.length());
            return build;
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    private Build fromInputStream(final InputStream inputStream, final long contentLength) {
        try {
            RequestBody requestBody = new RequestBody(){

                public MediaType contentType() {
                    return MediaType.parse((String)"application/octet-stream");
                }

                public long contentLength() throws IOException {
                    return contentLength;
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    Source source = null;
                    try {
                        source = Okio.source((InputStream)inputStream);
                        OutputStream os = sink.outputStream();
                        sink.writeAll(source);
                    }
                    catch (IOException e) {
                        throw KubernetesClientException.launderThrowable((String)"Can't instantiate binary build, due to error reading/writing stream. Can be caused if the output stream was closed by the server.", (Throwable)e);
                    }
                }
            };
            OkHttpClient newClient = this.client.newBuilder().readTimeout(this.timeout, this.timeoutUnit).writeTimeout(this.timeout, this.timeoutUnit).build();
            Request.Builder requestBuilder = new Request.Builder().post(requestBody).header("Expect", "100-continue").url(this.getQueryParameters());
            return (Build)this.handleResponse(newClient, requestBuilder, Build.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    private String getQueryParameters() throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        sb.append(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "instantiatebinary"}));
        if (Utils.isNullOrEmpty((String)this.message)) {
            sb.append("?commit=");
        } else {
            sb.append("?commit=").append(this.message);
        }
        if (!Utils.isNullOrEmpty((String)this.authorName)) {
            sb.append("&revision.authorName=").append(this.authorName);
        }
        if (!Utils.isNullOrEmpty((String)this.authorEmail)) {
            sb.append("&revision.authorEmail=").append(this.authorEmail);
        }
        if (!Utils.isNullOrEmpty((String)this.committerName)) {
            sb.append("&revision.committerName=").append(this.committerName);
        }
        if (!Utils.isNullOrEmpty((String)this.committerEmail)) {
            sb.append("&revision.committerEmail=").append(this.committerEmail);
        }
        if (!Utils.isNullOrEmpty((String)this.commit)) {
            sb.append("&revision.commit=").append(this.commit);
        }
        if (!Utils.isNullOrEmpty((String)this.asFile)) {
            sb.append("&asFile=").append(this.asFile);
        }
        return sb.toString();
    }

    @Override
    public TimeoutInputStreamable<Build> asFile(String fileName) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, this.message, fileName, this.timeout, this.timeoutUnit);
    }

    @Override
    public MessageAsFileTimeoutInputStreamable<Build> withAuthorEmail(String email) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, email, this.committerName, this.committerEmail, this.commit, this.message, this.asFile, this.timeout, this.timeoutUnit);
    }

    @Override
    public AuthorMessageAsFileTimeoutInputStreamable<Build> withCommitterEmail(String committerEmail) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, this.authorEmail, this.committerName, committerEmail, this.commit, this.message, this.asFile, this.timeout, this.timeoutUnit);
    }

    @Override
    public AsFileTimeoutInputStreamable<Build> withMessage(String message) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, message, this.asFile, this.timeout, this.timeoutUnit);
    }

    @Override
    public AuthorEmailable<MessageAsFileTimeoutInputStreamable<Build>> withAuthorName(String authorName) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, this.message, this.asFile, this.timeout, this.timeoutUnit);
    }

    @Override
    public CommitterEmailable<AuthorMessageAsFileTimeoutInputStreamable<Build>> withCommitterName(String committerName) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, this.authorEmail, committerName, this.committerEmail, this.commit, this.message, this.asFile, this.timeout, this.timeoutUnit);
    }

    public InputStreamable<Build> withTimeout(long timeout, TimeUnit unit) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, this.message, this.asFile, timeout, unit);
    }

    public InputStreamable<Build> withTimeoutInMillis(long timeoutInMillis) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.commit, this.message, this.asFile, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    private static class BuildConfigReaper
    implements Reaper {
        private BuildConfigOperationsImpl oper;

        public BuildConfigReaper(BuildConfigOperationsImpl oper) {
            this.oper = oper;
        }

        public boolean reap() {
            this.oper.deleteBuilds();
            return false;
        }
    }
}

