/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.models;

import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.models.V1alpha1Summary;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="ImageTag defines the image tag attributes")
public class V1alpha1ImageTag {
    @SerializedName(value="author")
    private String author = null;
    @SerializedName(value="created_at")
    private DateTime createdAt = null;
    @SerializedName(value="digest")
    private String digest = null;
    @SerializedName(value="level")
    private Integer level = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="scanStatus")
    private String scanStatus = null;
    @SerializedName(value="size")
    private String size = null;
    @SerializedName(value="summary")
    private List<V1alpha1Summary> summary = null;
    @SerializedName(value="updated_at")
    private DateTime updatedAt = null;

    public V1alpha1ImageTag author(String author) {
        this.author = author;
        return this;
    }

    @ApiModelProperty(value="Author defines the tag author Support for Harbor")
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public V1alpha1ImageTag createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="CreatedAt defines the tag created_at")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public V1alpha1ImageTag digest(String digest) {
        this.digest = digest;
        return this;
    }

    @ApiModelProperty(value="Digest defines the tag digest")
    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public V1alpha1ImageTag level(Integer level) {
        this.level = level;
        return this;
    }

    @ApiModelProperty(required=true, value="Level is the level of this tag")
    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public V1alpha1ImageTag message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(required=true, value="Message represent the message of this tag")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V1alpha1ImageTag name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name defines the tag name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1alpha1ImageTag scanStatus(String scanStatus) {
        this.scanStatus = scanStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="ScanStatus represent the scanstatus of this tag")
    public String getScanStatus() {
        return this.scanStatus;
    }

    public void setScanStatus(String scanStatus) {
        this.scanStatus = scanStatus;
    }

    public V1alpha1ImageTag size(String size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(required=true, value="Size is the size of this tag")
    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public V1alpha1ImageTag summary(List<V1alpha1Summary> summary) {
        this.summary = summary;
        return this;
    }

    public V1alpha1ImageTag addSummaryItem(V1alpha1Summary summaryItem) {
        if (this.summary == null) {
            this.summary = new ArrayList<V1alpha1Summary>();
        }
        this.summary.add(summaryItem);
        return this;
    }

    @ApiModelProperty(value="Summary of this tag")
    public List<V1alpha1Summary> getSummary() {
        return this.summary;
    }

    public void setSummary(List<V1alpha1Summary> summary) {
        this.summary = summary;
    }

    public V1alpha1ImageTag updatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(value="UpdatedAt defines the completion time of Harbor scan tag Support for Harbor")
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1ImageTag v1alpha1ImageTag = (V1alpha1ImageTag)o;
        return Objects.equals(this.author, v1alpha1ImageTag.author) && Objects.equals(this.createdAt, v1alpha1ImageTag.createdAt) && Objects.equals(this.digest, v1alpha1ImageTag.digest) && Objects.equals(this.level, v1alpha1ImageTag.level) && Objects.equals(this.message, v1alpha1ImageTag.message) && Objects.equals(this.name, v1alpha1ImageTag.name) && Objects.equals(this.scanStatus, v1alpha1ImageTag.scanStatus) && Objects.equals(this.size, v1alpha1ImageTag.size) && Objects.equals(this.summary, v1alpha1ImageTag.summary) && Objects.equals(this.updatedAt, v1alpha1ImageTag.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.author, this.createdAt, this.digest, this.level, this.message, this.name, this.scanStatus, this.size, this.summary, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1ImageTag {\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    digest: ").append(this.toIndentedString(this.digest)).append("\n");
        sb.append("    level: ").append(this.toIndentedString(this.level)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    scanStatus: ").append(this.toIndentedString(this.scanStatus)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

