package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ToolTypeStatusBuilder extends V1alpha1ToolTypeStatusFluentImpl<V1alpha1ToolTypeStatusBuilder> implements VisitableBuilder<V1alpha1ToolTypeStatus,V1alpha1ToolTypeStatusBuilder>{

    V1alpha1ToolTypeStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ToolTypeStatusBuilder(){
            this(true);
    }
    public V1alpha1ToolTypeStatusBuilder(Boolean validationEnabled){
            this(new V1alpha1ToolTypeStatus(), validationEnabled);
    }
    public V1alpha1ToolTypeStatusBuilder(V1alpha1ToolTypeStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ToolTypeStatusBuilder(V1alpha1ToolTypeStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ToolTypeStatus(), validationEnabled);
    }
    public V1alpha1ToolTypeStatusBuilder(V1alpha1ToolTypeStatusFluent<?> fluent,V1alpha1ToolTypeStatus instance){
            this(fluent, instance, true);
    }
    public V1alpha1ToolTypeStatusBuilder(V1alpha1ToolTypeStatusFluent<?> fluent,V1alpha1ToolTypeStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPhase(instance.getPhase());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ToolTypeStatusBuilder(V1alpha1ToolTypeStatus instance){
            this(instance,true);
    }
    public V1alpha1ToolTypeStatusBuilder(V1alpha1ToolTypeStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPhase(instance.getPhase());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ToolTypeStatus build(){
            V1alpha1ToolTypeStatus buildable = new V1alpha1ToolTypeStatus();
            buildable.setPhase(fluent.getPhase());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ToolTypeStatusBuilder that = (V1alpha1ToolTypeStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
