package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ToolCategoryRefBuilder extends V1alpha1ToolCategoryRefFluentImpl<V1alpha1ToolCategoryRefBuilder> implements VisitableBuilder<V1alpha1ToolCategoryRef,V1alpha1ToolCategoryRefBuilder>{

    V1alpha1ToolCategoryRefFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ToolCategoryRefBuilder(){
            this(true);
    }
    public V1alpha1ToolCategoryRefBuilder(Boolean validationEnabled){
            this(new V1alpha1ToolCategoryRef(), validationEnabled);
    }
    public V1alpha1ToolCategoryRefBuilder(V1alpha1ToolCategoryRefFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ToolCategoryRefBuilder(V1alpha1ToolCategoryRefFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ToolCategoryRef(), validationEnabled);
    }
    public V1alpha1ToolCategoryRefBuilder(V1alpha1ToolCategoryRefFluent<?> fluent,V1alpha1ToolCategoryRef instance){
            this(fluent, instance, true);
    }
    public V1alpha1ToolCategoryRefBuilder(V1alpha1ToolCategoryRefFluent<?> fluent,V1alpha1ToolCategoryRef instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiGroup(instance.getApiGroup());

            fluent.withKind(instance.getKind());

            fluent.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ToolCategoryRefBuilder(V1alpha1ToolCategoryRef instance){
            this(instance,true);
    }
    public V1alpha1ToolCategoryRefBuilder(V1alpha1ToolCategoryRef instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiGroup(instance.getApiGroup());

            this.withKind(instance.getKind());

            this.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ToolCategoryRef build(){
            V1alpha1ToolCategoryRef buildable = new V1alpha1ToolCategoryRef();
            buildable.setApiGroup(fluent.getApiGroup());
            buildable.setKind(fluent.getKind());
            buildable.setName(fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ToolCategoryRefBuilder that = (V1alpha1ToolCategoryRefBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
