package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ToolBindingReplicaListBuilder extends V1alpha1ToolBindingReplicaListFluentImpl<V1alpha1ToolBindingReplicaListBuilder> implements VisitableBuilder<V1alpha1ToolBindingReplicaList,V1alpha1ToolBindingReplicaListBuilder>{

    V1alpha1ToolBindingReplicaListFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ToolBindingReplicaListBuilder(){
            this(true);
    }
    public V1alpha1ToolBindingReplicaListBuilder(Boolean validationEnabled){
            this(new V1alpha1ToolBindingReplicaList(), validationEnabled);
    }
    public V1alpha1ToolBindingReplicaListBuilder(V1alpha1ToolBindingReplicaListFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ToolBindingReplicaListBuilder(V1alpha1ToolBindingReplicaListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ToolBindingReplicaList(), validationEnabled);
    }
    public V1alpha1ToolBindingReplicaListBuilder(V1alpha1ToolBindingReplicaListFluent<?> fluent,V1alpha1ToolBindingReplicaList instance){
            this(fluent, instance, true);
    }
    public V1alpha1ToolBindingReplicaListBuilder(V1alpha1ToolBindingReplicaListFluent<?> fluent,V1alpha1ToolBindingReplicaList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ToolBindingReplicaListBuilder(V1alpha1ToolBindingReplicaList instance){
            this(instance,true);
    }
    public V1alpha1ToolBindingReplicaListBuilder(V1alpha1ToolBindingReplicaList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ToolBindingReplicaList build(){
            V1alpha1ToolBindingReplicaList buildable = new V1alpha1ToolBindingReplicaList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ToolBindingReplicaListBuilder that = (V1alpha1ToolBindingReplicaListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
