package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ToolBindingBuilder extends V1alpha1ToolBindingFluentImpl<V1alpha1ToolBindingBuilder> implements VisitableBuilder<V1alpha1ToolBinding,V1alpha1ToolBindingBuilder>{

    V1alpha1ToolBindingFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ToolBindingBuilder(){
            this(true);
    }
    public V1alpha1ToolBindingBuilder(Boolean validationEnabled){
            this(new V1alpha1ToolBinding(), validationEnabled);
    }
    public V1alpha1ToolBindingBuilder(V1alpha1ToolBindingFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ToolBindingBuilder(V1alpha1ToolBindingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ToolBinding(), validationEnabled);
    }
    public V1alpha1ToolBindingBuilder(V1alpha1ToolBindingFluent<?> fluent,V1alpha1ToolBinding instance){
            this(fluent, instance, true);
    }
    public V1alpha1ToolBindingBuilder(V1alpha1ToolBindingFluent<?> fluent,V1alpha1ToolBinding instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withData(instance.getData());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ToolBindingBuilder(V1alpha1ToolBinding instance){
            this(instance,true);
    }
    public V1alpha1ToolBindingBuilder(V1alpha1ToolBinding instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withData(instance.getData());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ToolBinding build(){
            V1alpha1ToolBinding buildable = new V1alpha1ToolBinding();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setData(fluent.getData());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ToolBindingBuilder that = (V1alpha1ToolBindingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
