package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1SettingSpecBuilder extends V1alpha1SettingSpecFluentImpl<V1alpha1SettingSpecBuilder> implements VisitableBuilder<V1alpha1SettingSpec,V1alpha1SettingSpecBuilder>{

    V1alpha1SettingSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1SettingSpecBuilder(){
            this(true);
    }
    public V1alpha1SettingSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1SettingSpec(), validationEnabled);
    }
    public V1alpha1SettingSpecBuilder(V1alpha1SettingSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1SettingSpecBuilder(V1alpha1SettingSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1SettingSpec(), validationEnabled);
    }
    public V1alpha1SettingSpecBuilder(V1alpha1SettingSpecFluent<?> fluent,V1alpha1SettingSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1SettingSpecBuilder(V1alpha1SettingSpecFluent<?> fluent,V1alpha1SettingSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDefaultDomain(instance.getDefaultDomain());

            fluent.withVersionGate(instance.getVersionGate());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1SettingSpecBuilder(V1alpha1SettingSpec instance){
            this(instance,true);
    }
    public V1alpha1SettingSpecBuilder(V1alpha1SettingSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDefaultDomain(instance.getDefaultDomain());

            this.withVersionGate(instance.getVersionGate());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1SettingSpec build(){
            V1alpha1SettingSpec buildable = new V1alpha1SettingSpec();
            buildable.setDefaultDomain(fluent.getDefaultDomain());
            buildable.setVersionGate(fluent.getVersionGate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1SettingSpecBuilder that = (V1alpha1SettingSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
