package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1SettingListBuilder extends V1alpha1SettingListFluentImpl<V1alpha1SettingListBuilder> implements VisitableBuilder<V1alpha1SettingList,V1alpha1SettingListBuilder>{

    V1alpha1SettingListFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1SettingListBuilder(){
            this(true);
    }
    public V1alpha1SettingListBuilder(Boolean validationEnabled){
            this(new V1alpha1SettingList(), validationEnabled);
    }
    public V1alpha1SettingListBuilder(V1alpha1SettingListFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1SettingListBuilder(V1alpha1SettingListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1SettingList(), validationEnabled);
    }
    public V1alpha1SettingListBuilder(V1alpha1SettingListFluent<?> fluent,V1alpha1SettingList instance){
            this(fluent, instance, true);
    }
    public V1alpha1SettingListBuilder(V1alpha1SettingListFluent<?> fluent,V1alpha1SettingList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1SettingListBuilder(V1alpha1SettingList instance){
            this(instance,true);
    }
    public V1alpha1SettingListBuilder(V1alpha1SettingList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1SettingList build(){
            V1alpha1SettingList buildable = new V1alpha1SettingList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1SettingListBuilder that = (V1alpha1SettingListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
