package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1SecretKeySetRefBuilder extends V1alpha1SecretKeySetRefFluentImpl<V1alpha1SecretKeySetRefBuilder> implements VisitableBuilder<V1alpha1SecretKeySetRef,V1alpha1SecretKeySetRefBuilder>{

    V1alpha1SecretKeySetRefFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1SecretKeySetRefBuilder(){
            this(true);
    }
    public V1alpha1SecretKeySetRefBuilder(Boolean validationEnabled){
            this(new V1alpha1SecretKeySetRef(), validationEnabled);
    }
    public V1alpha1SecretKeySetRefBuilder(V1alpha1SecretKeySetRefFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1SecretKeySetRefBuilder(V1alpha1SecretKeySetRefFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1SecretKeySetRef(), validationEnabled);
    }
    public V1alpha1SecretKeySetRefBuilder(V1alpha1SecretKeySetRefFluent<?> fluent,V1alpha1SecretKeySetRef instance){
            this(fluent, instance, true);
    }
    public V1alpha1SecretKeySetRefBuilder(V1alpha1SecretKeySetRefFluent<?> fluent,V1alpha1SecretKeySetRef instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            fluent.withNamespace(instance.getNamespace());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1SecretKeySetRefBuilder(V1alpha1SecretKeySetRef instance){
            this(instance,true);
    }
    public V1alpha1SecretKeySetRefBuilder(V1alpha1SecretKeySetRef instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.withNamespace(instance.getNamespace());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1SecretKeySetRef build(){
            V1alpha1SecretKeySetRef buildable = new V1alpha1SecretKeySetRef();
            buildable.setName(fluent.getName());
            buildable.setNamespace(fluent.getNamespace());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1SecretKeySetRefBuilder that = (V1alpha1SecretKeySetRefBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
