package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineViewTemplateSpecBuilder extends V1alpha1PipelineViewTemplateSpecFluentImpl<V1alpha1PipelineViewTemplateSpecBuilder> implements VisitableBuilder<V1alpha1PipelineViewTemplateSpec,V1alpha1PipelineViewTemplateSpecBuilder>{

    V1alpha1PipelineViewTemplateSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineViewTemplateSpecBuilder(){
            this(true);
    }
    public V1alpha1PipelineViewTemplateSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineViewTemplateSpec(), validationEnabled);
    }
    public V1alpha1PipelineViewTemplateSpecBuilder(V1alpha1PipelineViewTemplateSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineViewTemplateSpecBuilder(V1alpha1PipelineViewTemplateSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineViewTemplateSpec(), validationEnabled);
    }
    public V1alpha1PipelineViewTemplateSpecBuilder(V1alpha1PipelineViewTemplateSpecFluent<?> fluent,V1alpha1PipelineViewTemplateSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineViewTemplateSpecBuilder(V1alpha1PipelineViewTemplateSpecFluent<?> fluent,V1alpha1PipelineViewTemplateSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withFieldPath(instance.getFieldPath());

            fluent.withKind(instance.getKind());

            fluent.withMarkdown(instance.getMarkdown());

            fluent.withName(instance.getName());

            fluent.withNamespace(instance.getNamespace());

            fluent.withResourceVersion(instance.getResourceVersion());

            fluent.withUid(instance.getUid());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineViewTemplateSpecBuilder(V1alpha1PipelineViewTemplateSpec instance){
            this(instance,true);
    }
    public V1alpha1PipelineViewTemplateSpecBuilder(V1alpha1PipelineViewTemplateSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withFieldPath(instance.getFieldPath());

            this.withKind(instance.getKind());

            this.withMarkdown(instance.getMarkdown());

            this.withName(instance.getName());

            this.withNamespace(instance.getNamespace());

            this.withResourceVersion(instance.getResourceVersion());

            this.withUid(instance.getUid());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineViewTemplateSpec build(){
            V1alpha1PipelineViewTemplateSpec buildable = new V1alpha1PipelineViewTemplateSpec();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setFieldPath(fluent.getFieldPath());
            buildable.setKind(fluent.getKind());
            buildable.setMarkdown(fluent.getMarkdown());
            buildable.setName(fluent.getName());
            buildable.setNamespace(fluent.getNamespace());
            buildable.setResourceVersion(fluent.getResourceVersion());
            buildable.setUid(fluent.getUid());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineViewTemplateSpecBuilder that = (V1alpha1PipelineViewTemplateSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
